/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSamplingTargetsRequest extends XRayRequest implements
        ToCopyableBuilder<GetSamplingTargetsRequest.Builder, GetSamplingTargetsRequest> {
    private static final SdkField<List<SamplingStatisticsDocument>> SAMPLING_STATISTICS_DOCUMENTS_FIELD = SdkField
            .<List<SamplingStatisticsDocument>> builder(MarshallingType.LIST)
            .memberName("SamplingStatisticsDocuments")
            .getter(getter(GetSamplingTargetsRequest::samplingStatisticsDocuments))
            .setter(setter(Builder::samplingStatisticsDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingStatisticsDocuments")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SamplingStatisticsDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(SamplingStatisticsDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SAMPLING_STATISTICS_DOCUMENTS_FIELD));

    private final List<SamplingStatisticsDocument> samplingStatisticsDocuments;

    private GetSamplingTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.samplingStatisticsDocuments = builder.samplingStatisticsDocuments;
    }

    /**
     * Returns true if the SamplingStatisticsDocuments property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasSamplingStatisticsDocuments() {
        return samplingStatisticsDocuments != null && !(samplingStatisticsDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about rules that the service is using to sample requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSamplingStatisticsDocuments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about rules that the service is using to sample requests.
     */
    public final List<SamplingStatisticsDocument> samplingStatisticsDocuments() {
        return samplingStatisticsDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSamplingStatisticsDocuments() ? samplingStatisticsDocuments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSamplingTargetsRequest)) {
            return false;
        }
        GetSamplingTargetsRequest other = (GetSamplingTargetsRequest) obj;
        return hasSamplingStatisticsDocuments() == other.hasSamplingStatisticsDocuments()
                && Objects.equals(samplingStatisticsDocuments(), other.samplingStatisticsDocuments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSamplingTargetsRequest")
                .add("SamplingStatisticsDocuments", hasSamplingStatisticsDocuments() ? samplingStatisticsDocuments() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SamplingStatisticsDocuments":
            return Optional.ofNullable(clazz.cast(samplingStatisticsDocuments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSamplingTargetsRequest, T> g) {
        return obj -> g.apply((GetSamplingTargetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSamplingTargetsRequest> {
        /**
         * <p>
         * Information about rules that the service is using to sample requests.
         * </p>
         * 
         * @param samplingStatisticsDocuments
         *        Information about rules that the service is using to sample requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingStatisticsDocuments(Collection<SamplingStatisticsDocument> samplingStatisticsDocuments);

        /**
         * <p>
         * Information about rules that the service is using to sample requests.
         * </p>
         * 
         * @param samplingStatisticsDocuments
         *        Information about rules that the service is using to sample requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingStatisticsDocuments(SamplingStatisticsDocument... samplingStatisticsDocuments);

        /**
         * <p>
         * Information about rules that the service is using to sample requests.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SamplingStatisticsDocument>.Builder}
         * avoiding the need to create one manually via {@link List<SamplingStatisticsDocument>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SamplingStatisticsDocument>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #samplingStatisticsDocuments(List<SamplingStatisticsDocument>)}.
         * 
         * @param samplingStatisticsDocuments
         *        a consumer that will call methods on {@link List<SamplingStatisticsDocument>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samplingStatisticsDocuments(List<SamplingStatisticsDocument>)
         */
        Builder samplingStatisticsDocuments(Consumer<SamplingStatisticsDocument.Builder>... samplingStatisticsDocuments);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private List<SamplingStatisticsDocument> samplingStatisticsDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSamplingTargetsRequest model) {
            super(model);
            samplingStatisticsDocuments(model.samplingStatisticsDocuments);
        }

        public final Collection<SamplingStatisticsDocument.Builder> getSamplingStatisticsDocuments() {
            if (samplingStatisticsDocuments instanceof SdkAutoConstructList) {
                return null;
            }
            return samplingStatisticsDocuments != null ? samplingStatisticsDocuments.stream()
                    .map(SamplingStatisticsDocument::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder samplingStatisticsDocuments(Collection<SamplingStatisticsDocument> samplingStatisticsDocuments) {
            this.samplingStatisticsDocuments = SamplingStatisticsDocumentListCopier.copy(samplingStatisticsDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingStatisticsDocuments(SamplingStatisticsDocument... samplingStatisticsDocuments) {
            samplingStatisticsDocuments(Arrays.asList(samplingStatisticsDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingStatisticsDocuments(
                Consumer<SamplingStatisticsDocument.Builder>... samplingStatisticsDocuments) {
            samplingStatisticsDocuments(Stream.of(samplingStatisticsDocuments)
                    .map(c -> SamplingStatisticsDocument.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSamplingStatisticsDocuments(
                Collection<SamplingStatisticsDocument.BuilderImpl> samplingStatisticsDocuments) {
            this.samplingStatisticsDocuments = SamplingStatisticsDocumentListCopier.copyFromBuilder(samplingStatisticsDocuments);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSamplingTargetsRequest build() {
            return new GetSamplingTargetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
