/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.xray.model.Insight;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInsightResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetInsightResponse> {
    private static final SdkField<Insight> INSIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Insight").getter(GetInsightResponse.getter(GetInsightResponse::insight)).setter(GetInsightResponse.setter(Builder::insight)).constructor(Insight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_FIELD));
    private final Insight insight;

    private GetInsightResponse(BuilderImpl builder) {
        super(builder);
        this.insight = builder.insight;
    }

    public Insight insight() {
        return this.insight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.insight());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightResponse)) {
            return false;
        }
        GetInsightResponse other = (GetInsightResponse)((Object)obj);
        return Objects.equals(this.insight(), other.insight());
    }

    public String toString() {
        return ToString.builder((String)"GetInsightResponse").add("Insight", (Object)this.insight()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Insight": {
                return Optional.ofNullable(clazz.cast(this.insight()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightResponse, T> g) {
        return obj -> g.apply((GetInsightResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private Insight insight;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightResponse model) {
            super(model);
            this.insight(model.insight);
        }

        public final Insight.Builder getInsight() {
            return this.insight != null ? this.insight.toBuilder() : null;
        }

        @Override
        public final Builder insight(Insight insight) {
            this.insight = insight;
            return this;
        }

        public final void setInsight(Insight.BuilderImpl insight) {
            this.insight = insight != null ? insight.build() : null;
        }

        @Override
        public GetInsightResponse build() {
            return new GetInsightResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInsightResponse> {
        public Builder insight(Insight var1);

        default public Builder insight(Consumer<Insight.Builder> insight) {
            return this.insight((Insight)((Insight.Builder)Insight.builder().applyMutation(insight)).build());
        }
    }
}

