/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.InsightEvent;
import software.amazon.awssdk.services.xray.model.InsightEventListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInsightEventsResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetInsightEventsResponse> {
    private static final SdkField<List<InsightEvent>> INSIGHT_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsightEvents").getter(GetInsightEventsResponse.getter(GetInsightEventsResponse::insightEvents)).setter(GetInsightEventsResponse.setter(Builder::insightEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetInsightEventsResponse.getter(GetInsightEventsResponse::nextToken)).setter(GetInsightEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<InsightEvent> insightEvents;
    private final String nextToken;

    private GetInsightEventsResponse(BuilderImpl builder) {
        super(builder);
        this.insightEvents = builder.insightEvents;
        this.nextToken = builder.nextToken;
    }

    public boolean hasInsightEvents() {
        return this.insightEvents != null && !(this.insightEvents instanceof SdkAutoConstructList);
    }

    public List<InsightEvent> insightEvents() {
        return this.insightEvents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsightEvents() ? this.insightEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightEventsResponse)) {
            return false;
        }
        GetInsightEventsResponse other = (GetInsightEventsResponse)((Object)obj);
        return this.hasInsightEvents() == other.hasInsightEvents() && Objects.equals(this.insightEvents(), other.insightEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetInsightEventsResponse").add("InsightEvents", this.hasInsightEvents() ? this.insightEvents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsightEvents": {
                return Optional.ofNullable(clazz.cast(this.insightEvents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightEventsResponse, T> g) {
        return obj -> g.apply((GetInsightEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<InsightEvent> insightEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightEventsResponse model) {
            super(model);
            this.insightEvents(model.insightEvents);
            this.nextToken(model.nextToken);
        }

        public final Collection<InsightEvent.Builder> getInsightEvents() {
            if (this.insightEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.insightEvents != null ? (Collection)this.insightEvents.stream().map(InsightEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder insightEvents(Collection<InsightEvent> insightEvents) {
            this.insightEvents = InsightEventListCopier.copy(insightEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightEvents(InsightEvent ... insightEvents) {
            this.insightEvents(Arrays.asList(insightEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightEvents(Consumer<InsightEvent.Builder> ... insightEvents) {
            this.insightEvents(Stream.of(insightEvents).map(c -> (InsightEvent)((InsightEvent.Builder)InsightEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInsightEvents(Collection<InsightEvent.BuilderImpl> insightEvents) {
            this.insightEvents = InsightEventListCopier.copyFromBuilder(insightEvents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetInsightEventsResponse build() {
            return new GetInsightEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInsightEventsResponse> {
        public Builder insightEvents(Collection<InsightEvent> var1);

        public Builder insightEvents(InsightEvent ... var1);

        public Builder insightEvents(Consumer<InsightEvent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

