/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.EdgeStatistics;
import software.amazon.awssdk.services.xray.model.HistogramCopier;
import software.amazon.awssdk.services.xray.model.HistogramEntry;
import software.amazon.awssdk.services.xray.model.ServiceStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeSeriesServiceStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeSeriesServiceStatistics> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TimeSeriesServiceStatistics.getter(TimeSeriesServiceStatistics::timestamp)).setter(TimeSeriesServiceStatistics.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<EdgeStatistics> EDGE_SUMMARY_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TimeSeriesServiceStatistics.getter(TimeSeriesServiceStatistics::edgeSummaryStatistics)).setter(TimeSeriesServiceStatistics.setter(Builder::edgeSummaryStatistics)).constructor(EdgeStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeSummaryStatistics").build()}).build();
    private static final SdkField<ServiceStatistics> SERVICE_SUMMARY_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TimeSeriesServiceStatistics.getter(TimeSeriesServiceStatistics::serviceSummaryStatistics)).setter(TimeSeriesServiceStatistics.setter(Builder::serviceSummaryStatistics)).constructor(ServiceStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSummaryStatistics").build()}).build();
    private static final SdkField<List<HistogramEntry>> RESPONSE_TIME_HISTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TimeSeriesServiceStatistics.getter(TimeSeriesServiceStatistics::responseTimeHistogram)).setter(TimeSeriesServiceStatistics.setter(Builder::responseTimeHistogram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTimeHistogram").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HistogramEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, EDGE_SUMMARY_STATISTICS_FIELD, SERVICE_SUMMARY_STATISTICS_FIELD, RESPONSE_TIME_HISTOGRAM_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final EdgeStatistics edgeSummaryStatistics;
    private final ServiceStatistics serviceSummaryStatistics;
    private final List<HistogramEntry> responseTimeHistogram;

    private TimeSeriesServiceStatistics(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.edgeSummaryStatistics = builder.edgeSummaryStatistics;
        this.serviceSummaryStatistics = builder.serviceSummaryStatistics;
        this.responseTimeHistogram = builder.responseTimeHistogram;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public EdgeStatistics edgeSummaryStatistics() {
        return this.edgeSummaryStatistics;
    }

    public ServiceStatistics serviceSummaryStatistics() {
        return this.serviceSummaryStatistics;
    }

    public boolean hasResponseTimeHistogram() {
        return this.responseTimeHistogram != null && !(this.responseTimeHistogram instanceof SdkAutoConstructList);
    }

    public List<HistogramEntry> responseTimeHistogram() {
        return this.responseTimeHistogram;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeSummaryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSummaryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTimeHistogram());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesServiceStatistics)) {
            return false;
        }
        TimeSeriesServiceStatistics other = (TimeSeriesServiceStatistics)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.edgeSummaryStatistics(), other.edgeSummaryStatistics()) && Objects.equals(this.serviceSummaryStatistics(), other.serviceSummaryStatistics()) && Objects.equals(this.responseTimeHistogram(), other.responseTimeHistogram());
    }

    public String toString() {
        return ToString.builder((String)"TimeSeriesServiceStatistics").add("Timestamp", (Object)this.timestamp()).add("EdgeSummaryStatistics", (Object)this.edgeSummaryStatistics()).add("ServiceSummaryStatistics", (Object)this.serviceSummaryStatistics()).add("ResponseTimeHistogram", this.responseTimeHistogram()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "EdgeSummaryStatistics": {
                return Optional.ofNullable(clazz.cast(this.edgeSummaryStatistics()));
            }
            case "ServiceSummaryStatistics": {
                return Optional.ofNullable(clazz.cast(this.serviceSummaryStatistics()));
            }
            case "ResponseTimeHistogram": {
                return Optional.ofNullable(clazz.cast(this.responseTimeHistogram()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesServiceStatistics, T> g) {
        return obj -> g.apply((TimeSeriesServiceStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private EdgeStatistics edgeSummaryStatistics;
        private ServiceStatistics serviceSummaryStatistics;
        private List<HistogramEntry> responseTimeHistogram = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesServiceStatistics model) {
            this.timestamp(model.timestamp);
            this.edgeSummaryStatistics(model.edgeSummaryStatistics);
            this.serviceSummaryStatistics(model.serviceSummaryStatistics);
            this.responseTimeHistogram(model.responseTimeHistogram);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final EdgeStatistics.Builder getEdgeSummaryStatistics() {
            return this.edgeSummaryStatistics != null ? this.edgeSummaryStatistics.toBuilder() : null;
        }

        @Override
        public final Builder edgeSummaryStatistics(EdgeStatistics edgeSummaryStatistics) {
            this.edgeSummaryStatistics = edgeSummaryStatistics;
            return this;
        }

        public final void setEdgeSummaryStatistics(EdgeStatistics.BuilderImpl edgeSummaryStatistics) {
            this.edgeSummaryStatistics = edgeSummaryStatistics != null ? edgeSummaryStatistics.build() : null;
        }

        public final ServiceStatistics.Builder getServiceSummaryStatistics() {
            return this.serviceSummaryStatistics != null ? this.serviceSummaryStatistics.toBuilder() : null;
        }

        @Override
        public final Builder serviceSummaryStatistics(ServiceStatistics serviceSummaryStatistics) {
            this.serviceSummaryStatistics = serviceSummaryStatistics;
            return this;
        }

        public final void setServiceSummaryStatistics(ServiceStatistics.BuilderImpl serviceSummaryStatistics) {
            this.serviceSummaryStatistics = serviceSummaryStatistics != null ? serviceSummaryStatistics.build() : null;
        }

        public final Collection<HistogramEntry.Builder> getResponseTimeHistogram() {
            return this.responseTimeHistogram != null ? (Collection)this.responseTimeHistogram.stream().map(HistogramEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copy(responseTimeHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(HistogramEntry ... responseTimeHistogram) {
            this.responseTimeHistogram(Arrays.asList(responseTimeHistogram));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(Consumer<HistogramEntry.Builder> ... responseTimeHistogram) {
            this.responseTimeHistogram(Stream.of(responseTimeHistogram).map(c -> (HistogramEntry)((HistogramEntry.Builder)HistogramEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResponseTimeHistogram(Collection<HistogramEntry.BuilderImpl> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copyFromBuilder(responseTimeHistogram);
        }

        public TimeSeriesServiceStatistics build() {
            return new TimeSeriesServiceStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeSeriesServiceStatistics> {
        public Builder timestamp(Instant var1);

        public Builder edgeSummaryStatistics(EdgeStatistics var1);

        default public Builder edgeSummaryStatistics(Consumer<EdgeStatistics.Builder> edgeSummaryStatistics) {
            return this.edgeSummaryStatistics((EdgeStatistics)((EdgeStatistics.Builder)EdgeStatistics.builder().applyMutation(edgeSummaryStatistics)).build());
        }

        public Builder serviceSummaryStatistics(ServiceStatistics var1);

        default public Builder serviceSummaryStatistics(Consumer<ServiceStatistics.Builder> serviceSummaryStatistics) {
            return this.serviceSummaryStatistics((ServiceStatistics)((ServiceStatistics.Builder)ServiceStatistics.builder().applyMutation(serviceSummaryStatistics)).build());
        }

        public Builder responseTimeHistogram(Collection<HistogramEntry> var1);

        public Builder responseTimeHistogram(HistogramEntry ... var1);

        public Builder responseTimeHistogram(Consumer<HistogramEntry.Builder> ... var1);
    }
}

