/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an application that processed requests, users that made requests, or downstream services, resources
 * and applications that an application used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Service implements SdkPojo, Serializable, ToCopyableBuilder<Service.Builder, Service> {
    private static final SdkField<Integer> REFERENCE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Service::referenceId)).setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Service::names))
            .setter(setter(Builder::names))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ROOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Service::root)).setter(setter(Builder::root))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Root").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Service::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Service::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<List<Edge>> EDGES_FIELD = SdkField
            .<List<Edge>> builder(MarshallingType.LIST)
            .getter(getter(Service::edges))
            .setter(setter(Builder::edges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Edge> builder(MarshallingType.SDK_POJO)
                                            .constructor(Edge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ServiceStatistics> SUMMARY_STATISTICS_FIELD = SdkField
            .<ServiceStatistics> builder(MarshallingType.SDK_POJO).getter(getter(Service::summaryStatistics))
            .setter(setter(Builder::summaryStatistics)).constructor(ServiceStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryStatistics").build()).build();

    private static final SdkField<List<HistogramEntry>> DURATION_HISTOGRAM_FIELD = SdkField
            .<List<HistogramEntry>> builder(MarshallingType.LIST)
            .getter(getter(Service::durationHistogram))
            .setter(setter(Builder::durationHistogram))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationHistogram").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HistogramEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(HistogramEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HistogramEntry>> RESPONSE_TIME_HISTOGRAM_FIELD = SdkField
            .<List<HistogramEntry>> builder(MarshallingType.LIST)
            .getter(getter(Service::responseTimeHistogram))
            .setter(setter(Builder::responseTimeHistogram))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTimeHistogram").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HistogramEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(HistogramEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ID_FIELD,
            NAME_FIELD, NAMES_FIELD, ROOT_FIELD, ACCOUNT_ID_FIELD, TYPE_FIELD, STATE_FIELD, START_TIME_FIELD, END_TIME_FIELD,
            EDGES_FIELD, SUMMARY_STATISTICS_FIELD, DURATION_HISTOGRAM_FIELD, RESPONSE_TIME_HISTOGRAM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer referenceId;

    private final String name;

    private final List<String> names;

    private final Boolean root;

    private final String accountId;

    private final String type;

    private final String state;

    private final Instant startTime;

    private final Instant endTime;

    private final List<Edge> edges;

    private final ServiceStatistics summaryStatistics;

    private final List<HistogramEntry> durationHistogram;

    private final List<HistogramEntry> responseTimeHistogram;

    private Service(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.name = builder.name;
        this.names = builder.names;
        this.root = builder.root;
        this.accountId = builder.accountId;
        this.type = builder.type;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.edges = builder.edges;
        this.summaryStatistics = builder.summaryStatistics;
        this.durationHistogram = builder.durationHistogram;
        this.responseTimeHistogram = builder.responseTimeHistogram;
    }

    /**
     * <p>
     * Identifier for the service. Unique within the service map.
     * </p>
     * 
     * @return Identifier for the service. Unique within the service map.
     */
    public Integer referenceId() {
        return referenceId;
    }

    /**
     * <p>
     * The canonical name of the service.
     * </p>
     * 
     * @return The canonical name of the service.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Names property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNames() {
        return names != null && !(names instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names for the service, including the canonical name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of names for the service, including the canonical name.
     */
    public List<String> names() {
        return names;
    }

    /**
     * <p>
     * Indicates that the service was the first service to process a request.
     * </p>
     * 
     * @return Indicates that the service was the first service to process a request.
     */
    public Boolean root() {
        return root;
    }

    /**
     * <p>
     * Identifier of the AWS account in which the service runs.
     * </p>
     * 
     * @return Identifier of the AWS account in which the service runs.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The type of service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS Resource - The type of an AWS resource. For example, <code>AWS::EC2::Instance</code> for a application
     * running on Amazon EC2 or <code>AWS::DynamoDB::Table</code> for an Amazon DynamoDB table that the application
     * used.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Service - The type of an AWS service. For example, <code>AWS::DynamoDB</code> for downstream calls to Amazon
     * DynamoDB that didn't target a specific table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client</code> - Represents the clients that sent requests to a root service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>remote</code> - A downstream service of indeterminate type.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of service.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AWS Resource - The type of an AWS resource. For example, <code>AWS::EC2::Instance</code> for a
     *         application running on Amazon EC2 or <code>AWS::DynamoDB::Table</code> for an Amazon DynamoDB table that
     *         the application used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AWS Service - The type of an AWS service. For example, <code>AWS::DynamoDB</code> for downstream calls to
     *         Amazon DynamoDB that didn't target a specific table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client</code> - Represents the clients that sent requests to a root service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>remote</code> - A downstream service of indeterminate type.
     *         </p>
     *         </li>
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The service's state.
     * </p>
     * 
     * @return The service's state.
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The start time of the first segment that the service generated.
     * </p>
     * 
     * @return The start time of the first segment that the service generated.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the last segment that the service generated.
     * </p>
     * 
     * @return The end time of the last segment that the service generated.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * Returns true if the Edges property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEdges() {
        return edges != null && !(edges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Connections to downstream services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEdges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Connections to downstream services.
     */
    public List<Edge> edges() {
        return edges;
    }

    /**
     * <p>
     * Aggregated statistics for the service.
     * </p>
     * 
     * @return Aggregated statistics for the service.
     */
    public ServiceStatistics summaryStatistics() {
        return summaryStatistics;
    }

    /**
     * Returns true if the DurationHistogram property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDurationHistogram() {
        return durationHistogram != null && !(durationHistogram instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A histogram that maps the spread of service durations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDurationHistogram()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A histogram that maps the spread of service durations.
     */
    public List<HistogramEntry> durationHistogram() {
        return durationHistogram;
    }

    /**
     * Returns true if the ResponseTimeHistogram property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResponseTimeHistogram() {
        return responseTimeHistogram != null && !(responseTimeHistogram instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A histogram that maps the spread of service response times.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponseTimeHistogram()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A histogram that maps the spread of service response times.
     */
    public List<HistogramEntry> responseTimeHistogram() {
        return responseTimeHistogram;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(names());
        hashCode = 31 * hashCode + Objects.hashCode(root());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(edges());
        hashCode = 31 * hashCode + Objects.hashCode(summaryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(durationHistogram());
        hashCode = 31 * hashCode + Objects.hashCode(responseTimeHistogram());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        return Objects.equals(referenceId(), other.referenceId()) && Objects.equals(name(), other.name())
                && Objects.equals(names(), other.names()) && Objects.equals(root(), other.root())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(type(), other.type())
                && Objects.equals(state(), other.state()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(edges(), other.edges())
                && Objects.equals(summaryStatistics(), other.summaryStatistics())
                && Objects.equals(durationHistogram(), other.durationHistogram())
                && Objects.equals(responseTimeHistogram(), other.responseTimeHistogram());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Service").add("ReferenceId", referenceId()).add("Name", name()).add("Names", names())
                .add("Root", root()).add("AccountId", accountId()).add("Type", type()).add("State", state())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("Edges", edges())
                .add("SummaryStatistics", summaryStatistics()).add("DurationHistogram", durationHistogram())
                .add("ResponseTimeHistogram", responseTimeHistogram()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReferenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Names":
            return Optional.ofNullable(clazz.cast(names()));
        case "Root":
            return Optional.ofNullable(clazz.cast(root()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Edges":
            return Optional.ofNullable(clazz.cast(edges()));
        case "SummaryStatistics":
            return Optional.ofNullable(clazz.cast(summaryStatistics()));
        case "DurationHistogram":
            return Optional.ofNullable(clazz.cast(durationHistogram()));
        case "ResponseTimeHistogram":
            return Optional.ofNullable(clazz.cast(responseTimeHistogram()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * Identifier for the service. Unique within the service map.
         * </p>
         * 
         * @param referenceId
         *        Identifier for the service. Unique within the service map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(Integer referenceId);

        /**
         * <p>
         * The canonical name of the service.
         * </p>
         * 
         * @param name
         *        The canonical name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of names for the service, including the canonical name.
         * </p>
         * 
         * @param names
         *        A list of names for the service, including the canonical name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * A list of names for the service, including the canonical name.
         * </p>
         * 
         * @param names
         *        A list of names for the service, including the canonical name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);

        /**
         * <p>
         * Indicates that the service was the first service to process a request.
         * </p>
         * 
         * @param root
         *        Indicates that the service was the first service to process a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder root(Boolean root);

        /**
         * <p>
         * Identifier of the AWS account in which the service runs.
         * </p>
         * 
         * @param accountId
         *        Identifier of the AWS account in which the service runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The type of service.
         * </p>
         * <ul>
         * <li>
         * <p>
         * AWS Resource - The type of an AWS resource. For example, <code>AWS::EC2::Instance</code> for a application
         * running on Amazon EC2 or <code>AWS::DynamoDB::Table</code> for an Amazon DynamoDB table that the application
         * used.
         * </p>
         * </li>
         * <li>
         * <p>
         * AWS Service - The type of an AWS service. For example, <code>AWS::DynamoDB</code> for downstream calls to
         * Amazon DynamoDB that didn't target a specific table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client</code> - Represents the clients that sent requests to a root service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>remote</code> - A downstream service of indeterminate type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of service.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AWS Resource - The type of an AWS resource. For example, <code>AWS::EC2::Instance</code> for a
         *        application running on Amazon EC2 or <code>AWS::DynamoDB::Table</code> for an Amazon DynamoDB table
         *        that the application used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AWS Service - The type of an AWS service. For example, <code>AWS::DynamoDB</code> for downstream calls
         *        to Amazon DynamoDB that didn't target a specific table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client</code> - Represents the clients that sent requests to a root service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>remote</code> - A downstream service of indeterminate type.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The service's state.
         * </p>
         * 
         * @param state
         *        The service's state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The start time of the first segment that the service generated.
         * </p>
         * 
         * @param startTime
         *        The start time of the first segment that the service generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the last segment that the service generated.
         * </p>
         * 
         * @param endTime
         *        The end time of the last segment that the service generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Connections to downstream services.
         * </p>
         * 
         * @param edges
         *        Connections to downstream services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edges(Collection<Edge> edges);

        /**
         * <p>
         * Connections to downstream services.
         * </p>
         * 
         * @param edges
         *        Connections to downstream services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edges(Edge... edges);

        /**
         * <p>
         * Connections to downstream services.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Edge>.Builder} avoiding the need to create
         * one manually via {@link List<Edge>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Edge>.Builder#build()} is called immediately and its result
         * is passed to {@link #edges(List<Edge>)}.
         * 
         * @param edges
         *        a consumer that will call methods on {@link List<Edge>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edges(List<Edge>)
         */
        Builder edges(Consumer<Edge.Builder>... edges);

        /**
         * <p>
         * Aggregated statistics for the service.
         * </p>
         * 
         * @param summaryStatistics
         *        Aggregated statistics for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryStatistics(ServiceStatistics summaryStatistics);

        /**
         * <p>
         * Aggregated statistics for the service.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceStatistics.Builder} avoiding the need to
         * create one manually via {@link ServiceStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #summaryStatistics(ServiceStatistics)}.
         * 
         * @param summaryStatistics
         *        a consumer that will call methods on {@link ServiceStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryStatistics(ServiceStatistics)
         */
        default Builder summaryStatistics(Consumer<ServiceStatistics.Builder> summaryStatistics) {
            return summaryStatistics(ServiceStatistics.builder().applyMutation(summaryStatistics).build());
        }

        /**
         * <p>
         * A histogram that maps the spread of service durations.
         * </p>
         * 
         * @param durationHistogram
         *        A histogram that maps the spread of service durations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationHistogram(Collection<HistogramEntry> durationHistogram);

        /**
         * <p>
         * A histogram that maps the spread of service durations.
         * </p>
         * 
         * @param durationHistogram
         *        A histogram that maps the spread of service durations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationHistogram(HistogramEntry... durationHistogram);

        /**
         * <p>
         * A histogram that maps the spread of service durations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HistogramEntry>.Builder} avoiding the need
         * to create one manually via {@link List<HistogramEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HistogramEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #durationHistogram(List<HistogramEntry>)}.
         * 
         * @param durationHistogram
         *        a consumer that will call methods on {@link List<HistogramEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #durationHistogram(List<HistogramEntry>)
         */
        Builder durationHistogram(Consumer<HistogramEntry.Builder>... durationHistogram);

        /**
         * <p>
         * A histogram that maps the spread of service response times.
         * </p>
         * 
         * @param responseTimeHistogram
         *        A histogram that maps the spread of service response times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram);

        /**
         * <p>
         * A histogram that maps the spread of service response times.
         * </p>
         * 
         * @param responseTimeHistogram
         *        A histogram that maps the spread of service response times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTimeHistogram(HistogramEntry... responseTimeHistogram);

        /**
         * <p>
         * A histogram that maps the spread of service response times.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HistogramEntry>.Builder} avoiding the need
         * to create one manually via {@link List<HistogramEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HistogramEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #responseTimeHistogram(List<HistogramEntry>)}.
         * 
         * @param responseTimeHistogram
         *        a consumer that will call methods on {@link List<HistogramEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseTimeHistogram(List<HistogramEntry>)
         */
        Builder responseTimeHistogram(Consumer<HistogramEntry.Builder>... responseTimeHistogram);
    }

    static final class BuilderImpl implements Builder {
        private Integer referenceId;

        private String name;

        private List<String> names = DefaultSdkAutoConstructList.getInstance();

        private Boolean root;

        private String accountId;

        private String type;

        private String state;

        private Instant startTime;

        private Instant endTime;

        private List<Edge> edges = DefaultSdkAutoConstructList.getInstance();

        private ServiceStatistics summaryStatistics;

        private List<HistogramEntry> durationHistogram = DefaultSdkAutoConstructList.getInstance();

        private List<HistogramEntry> responseTimeHistogram = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            referenceId(model.referenceId);
            name(model.name);
            names(model.names);
            root(model.root);
            accountId(model.accountId);
            type(model.type);
            state(model.state);
            startTime(model.startTime);
            endTime(model.endTime);
            edges(model.edges);
            summaryStatistics(model.summaryStatistics);
            durationHistogram(model.durationHistogram);
            responseTimeHistogram(model.responseTimeHistogram);
        }

        public final Integer getReferenceId() {
            return referenceId;
        }

        @Override
        public final Builder referenceId(Integer referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(Integer referenceId) {
            this.referenceId = referenceId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getNames() {
            return names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String... names) {
            names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
        }

        public final Boolean getRoot() {
            return root;
        }

        @Override
        public final Builder root(Boolean root) {
            this.root = root;
            return this;
        }

        public final void setRoot(Boolean root) {
            this.root = root;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<Edge.Builder> getEdges() {
            return edges != null ? edges.stream().map(Edge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder edges(Collection<Edge> edges) {
            this.edges = EdgeListCopier.copy(edges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Edge... edges) {
            edges(Arrays.asList(edges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Consumer<Edge.Builder>... edges) {
            edges(Stream.of(edges).map(c -> Edge.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEdges(Collection<Edge.BuilderImpl> edges) {
            this.edges = EdgeListCopier.copyFromBuilder(edges);
        }

        public final ServiceStatistics.Builder getSummaryStatistics() {
            return summaryStatistics != null ? summaryStatistics.toBuilder() : null;
        }

        @Override
        public final Builder summaryStatistics(ServiceStatistics summaryStatistics) {
            this.summaryStatistics = summaryStatistics;
            return this;
        }

        public final void setSummaryStatistics(ServiceStatistics.BuilderImpl summaryStatistics) {
            this.summaryStatistics = summaryStatistics != null ? summaryStatistics.build() : null;
        }

        public final Collection<HistogramEntry.Builder> getDurationHistogram() {
            return durationHistogram != null ? durationHistogram.stream().map(HistogramEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder durationHistogram(Collection<HistogramEntry> durationHistogram) {
            this.durationHistogram = HistogramCopier.copy(durationHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder durationHistogram(HistogramEntry... durationHistogram) {
            durationHistogram(Arrays.asList(durationHistogram));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder durationHistogram(Consumer<HistogramEntry.Builder>... durationHistogram) {
            durationHistogram(Stream.of(durationHistogram).map(c -> HistogramEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDurationHistogram(Collection<HistogramEntry.BuilderImpl> durationHistogram) {
            this.durationHistogram = HistogramCopier.copyFromBuilder(durationHistogram);
        }

        public final Collection<HistogramEntry.Builder> getResponseTimeHistogram() {
            return responseTimeHistogram != null ? responseTimeHistogram.stream().map(HistogramEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copy(responseTimeHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(HistogramEntry... responseTimeHistogram) {
            responseTimeHistogram(Arrays.asList(responseTimeHistogram));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(Consumer<HistogramEntry.Builder>... responseTimeHistogram) {
            responseTimeHistogram(Stream.of(responseTimeHistogram).map(c -> HistogramEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResponseTimeHistogram(Collection<HistogramEntry.BuilderImpl> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copyFromBuilder(responseTimeHistogram);
        }

        @Override
        public Service build() {
            return new Service(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
