/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <a>SamplingRule</a> and its metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamplingRuleRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<SamplingRuleRecord.Builder, SamplingRuleRecord> {
    private static final SdkField<SamplingRule> SAMPLING_RULE_FIELD = SdkField.<SamplingRule> builder(MarshallingType.SDK_POJO)
            .getter(getter(SamplingRuleRecord::samplingRule)).setter(setter(Builder::samplingRule))
            .constructor(SamplingRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingRule").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SamplingRuleRecord::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SamplingRuleRecord::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLING_RULE_FIELD,
            CREATED_AT_FIELD, MODIFIED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SamplingRule samplingRule;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private SamplingRuleRecord(BuilderImpl builder) {
        this.samplingRule = builder.samplingRule;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    /**
     * <p>
     * The sampling rule.
     * </p>
     * 
     * @return The sampling rule.
     */
    public SamplingRule samplingRule() {
        return samplingRule;
    }

    /**
     * <p>
     * When the rule was created.
     * </p>
     * 
     * @return When the rule was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * When the rule was last modified.
     * </p>
     * 
     * @return When the rule was last modified.
     */
    public Instant modifiedAt() {
        return modifiedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(samplingRule());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingRuleRecord)) {
            return false;
        }
        SamplingRuleRecord other = (SamplingRuleRecord) obj;
        return Objects.equals(samplingRule(), other.samplingRule()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SamplingRuleRecord").add("SamplingRule", samplingRule()).add("CreatedAt", createdAt())
                .add("ModifiedAt", modifiedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SamplingRule":
            return Optional.ofNullable(clazz.cast(samplingRule()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SamplingRuleRecord, T> g) {
        return obj -> g.apply((SamplingRuleRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamplingRuleRecord> {
        /**
         * <p>
         * The sampling rule.
         * </p>
         * 
         * @param samplingRule
         *        The sampling rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingRule(SamplingRule samplingRule);

        /**
         * <p>
         * The sampling rule.
         * </p>
         * This is a convenience that creates an instance of the {@link SamplingRule.Builder} avoiding the need to
         * create one manually via {@link SamplingRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link SamplingRule.Builder#build()} is called immediately and its
         * result is passed to {@link #samplingRule(SamplingRule)}.
         * 
         * @param samplingRule
         *        a consumer that will call methods on {@link SamplingRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samplingRule(SamplingRule)
         */
        default Builder samplingRule(Consumer<SamplingRule.Builder> samplingRule) {
            return samplingRule(SamplingRule.builder().applyMutation(samplingRule).build());
        }

        /**
         * <p>
         * When the rule was created.
         * </p>
         * 
         * @param createdAt
         *        When the rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * When the rule was last modified.
         * </p>
         * 
         * @param modifiedAt
         *        When the rule was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);
    }

    static final class BuilderImpl implements Builder {
        private SamplingRule samplingRule;

        private Instant createdAt;

        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingRuleRecord model) {
            samplingRule(model.samplingRule);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
        }

        public final SamplingRule.Builder getSamplingRule() {
            return samplingRule != null ? samplingRule.toBuilder() : null;
        }

        @Override
        public final Builder samplingRule(SamplingRule samplingRule) {
            this.samplingRule = samplingRule;
            return this;
        }

        public final void setSamplingRule(SamplingRule.BuilderImpl samplingRule) {
            this.samplingRule = samplingRule != null ? samplingRule.build() : null;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public SamplingRuleRecord build() {
            return new SamplingRuleRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
