/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a connection between two services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Edge implements SdkPojo, Serializable, ToCopyableBuilder<Edge.Builder, Edge> {
    private static final SdkField<Integer> REFERENCE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Edge::referenceId)).setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Edge::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Edge::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<EdgeStatistics> SUMMARY_STATISTICS_FIELD = SdkField
            .<EdgeStatistics> builder(MarshallingType.SDK_POJO).getter(getter(Edge::summaryStatistics))
            .setter(setter(Builder::summaryStatistics)).constructor(EdgeStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryStatistics").build()).build();

    private static final SdkField<List<HistogramEntry>> RESPONSE_TIME_HISTOGRAM_FIELD = SdkField
            .<List<HistogramEntry>> builder(MarshallingType.LIST)
            .getter(getter(Edge::responseTimeHistogram))
            .setter(setter(Builder::responseTimeHistogram))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTimeHistogram").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HistogramEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(HistogramEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Alias>> ALIASES_FIELD = SdkField
            .<List<Alias>> builder(MarshallingType.LIST)
            .getter(getter(Edge::aliases))
            .setter(setter(Builder::aliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Alias> builder(MarshallingType.SDK_POJO)
                                            .constructor(Alias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ID_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, SUMMARY_STATISTICS_FIELD, RESPONSE_TIME_HISTOGRAM_FIELD, ALIASES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer referenceId;

    private final Instant startTime;

    private final Instant endTime;

    private final EdgeStatistics summaryStatistics;

    private final List<HistogramEntry> responseTimeHistogram;

    private final List<Alias> aliases;

    private Edge(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.summaryStatistics = builder.summaryStatistics;
        this.responseTimeHistogram = builder.responseTimeHistogram;
        this.aliases = builder.aliases;
    }

    /**
     * <p>
     * Identifier of the edge. Unique within a service map.
     * </p>
     * 
     * @return Identifier of the edge. Unique within a service map.
     */
    public Integer referenceId() {
        return referenceId;
    }

    /**
     * <p>
     * The start time of the first segment on the edge.
     * </p>
     * 
     * @return The start time of the first segment on the edge.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the last segment on the edge.
     * </p>
     * 
     * @return The end time of the last segment on the edge.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Response statistics for segments on the edge.
     * </p>
     * 
     * @return Response statistics for segments on the edge.
     */
    public EdgeStatistics summaryStatistics() {
        return summaryStatistics;
    }

    /**
     * Returns true if the ResponseTimeHistogram property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResponseTimeHistogram() {
        return responseTimeHistogram != null && !(responseTimeHistogram instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A histogram that maps the spread of client response times on an edge.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponseTimeHistogram()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A histogram that maps the spread of client response times on an edge.
     */
    public List<HistogramEntry> responseTimeHistogram() {
        return responseTimeHistogram;
    }

    /**
     * Returns true if the Aliases property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAliases() {
        return aliases != null && !(aliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Aliases for the edge.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAliases()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Aliases for the edge.
     */
    public List<Alias> aliases() {
        return aliases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(summaryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(responseTimeHistogram());
        hashCode = 31 * hashCode + Objects.hashCode(aliases());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge) obj;
        return Objects.equals(referenceId(), other.referenceId()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(summaryStatistics(), other.summaryStatistics())
                && Objects.equals(responseTimeHistogram(), other.responseTimeHistogram())
                && Objects.equals(aliases(), other.aliases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Edge").add("ReferenceId", referenceId()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("SummaryStatistics", summaryStatistics()).add("ResponseTimeHistogram", responseTimeHistogram())
                .add("Aliases", aliases()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReferenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "SummaryStatistics":
            return Optional.ofNullable(clazz.cast(summaryStatistics()));
        case "ResponseTimeHistogram":
            return Optional.ofNullable(clazz.cast(responseTimeHistogram()));
        case "Aliases":
            return Optional.ofNullable(clazz.cast(aliases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Edge, T> g) {
        return obj -> g.apply((Edge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Edge> {
        /**
         * <p>
         * Identifier of the edge. Unique within a service map.
         * </p>
         * 
         * @param referenceId
         *        Identifier of the edge. Unique within a service map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(Integer referenceId);

        /**
         * <p>
         * The start time of the first segment on the edge.
         * </p>
         * 
         * @param startTime
         *        The start time of the first segment on the edge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the last segment on the edge.
         * </p>
         * 
         * @param endTime
         *        The end time of the last segment on the edge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Response statistics for segments on the edge.
         * </p>
         * 
         * @param summaryStatistics
         *        Response statistics for segments on the edge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryStatistics(EdgeStatistics summaryStatistics);

        /**
         * <p>
         * Response statistics for segments on the edge.
         * </p>
         * This is a convenience that creates an instance of the {@link EdgeStatistics.Builder} avoiding the need to
         * create one manually via {@link EdgeStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link EdgeStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #summaryStatistics(EdgeStatistics)}.
         * 
         * @param summaryStatistics
         *        a consumer that will call methods on {@link EdgeStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryStatistics(EdgeStatistics)
         */
        default Builder summaryStatistics(Consumer<EdgeStatistics.Builder> summaryStatistics) {
            return summaryStatistics(EdgeStatistics.builder().applyMutation(summaryStatistics).build());
        }

        /**
         * <p>
         * A histogram that maps the spread of client response times on an edge.
         * </p>
         * 
         * @param responseTimeHistogram
         *        A histogram that maps the spread of client response times on an edge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram);

        /**
         * <p>
         * A histogram that maps the spread of client response times on an edge.
         * </p>
         * 
         * @param responseTimeHistogram
         *        A histogram that maps the spread of client response times on an edge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTimeHistogram(HistogramEntry... responseTimeHistogram);

        /**
         * <p>
         * A histogram that maps the spread of client response times on an edge.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HistogramEntry>.Builder} avoiding the need
         * to create one manually via {@link List<HistogramEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HistogramEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #responseTimeHistogram(List<HistogramEntry>)}.
         * 
         * @param responseTimeHistogram
         *        a consumer that will call methods on {@link List<HistogramEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseTimeHistogram(List<HistogramEntry>)
         */
        Builder responseTimeHistogram(Consumer<HistogramEntry.Builder>... responseTimeHistogram);

        /**
         * <p>
         * Aliases for the edge.
         * </p>
         * 
         * @param aliases
         *        Aliases for the edge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Collection<Alias> aliases);

        /**
         * <p>
         * Aliases for the edge.
         * </p>
         * 
         * @param aliases
         *        Aliases for the edge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Alias... aliases);

        /**
         * <p>
         * Aliases for the edge.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Alias>.Builder} avoiding the need to create
         * one manually via {@link List<Alias>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Alias>.Builder#build()} is called immediately and its result
         * is passed to {@link #aliases(List<Alias>)}.
         * 
         * @param aliases
         *        a consumer that will call methods on {@link List<Alias>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliases(List<Alias>)
         */
        Builder aliases(Consumer<Alias.Builder>... aliases);
    }

    static final class BuilderImpl implements Builder {
        private Integer referenceId;

        private Instant startTime;

        private Instant endTime;

        private EdgeStatistics summaryStatistics;

        private List<HistogramEntry> responseTimeHistogram = DefaultSdkAutoConstructList.getInstance();

        private List<Alias> aliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Edge model) {
            referenceId(model.referenceId);
            startTime(model.startTime);
            endTime(model.endTime);
            summaryStatistics(model.summaryStatistics);
            responseTimeHistogram(model.responseTimeHistogram);
            aliases(model.aliases);
        }

        public final Integer getReferenceId() {
            return referenceId;
        }

        @Override
        public final Builder referenceId(Integer referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(Integer referenceId) {
            this.referenceId = referenceId;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final EdgeStatistics.Builder getSummaryStatistics() {
            return summaryStatistics != null ? summaryStatistics.toBuilder() : null;
        }

        @Override
        public final Builder summaryStatistics(EdgeStatistics summaryStatistics) {
            this.summaryStatistics = summaryStatistics;
            return this;
        }

        public final void setSummaryStatistics(EdgeStatistics.BuilderImpl summaryStatistics) {
            this.summaryStatistics = summaryStatistics != null ? summaryStatistics.build() : null;
        }

        public final Collection<HistogramEntry.Builder> getResponseTimeHistogram() {
            return responseTimeHistogram != null ? responseTimeHistogram.stream().map(HistogramEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copy(responseTimeHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(HistogramEntry... responseTimeHistogram) {
            responseTimeHistogram(Arrays.asList(responseTimeHistogram));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(Consumer<HistogramEntry.Builder>... responseTimeHistogram) {
            responseTimeHistogram(Stream.of(responseTimeHistogram).map(c -> HistogramEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResponseTimeHistogram(Collection<HistogramEntry.BuilderImpl> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copyFromBuilder(responseTimeHistogram);
        }

        public final Collection<Alias.Builder> getAliases() {
            return aliases != null ? aliases.stream().map(Alias::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aliases(Collection<Alias> aliases) {
            this.aliases = AliasListCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Alias... aliases) {
            aliases(Arrays.asList(aliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Consumer<Alias.Builder>... aliases) {
            aliases(Stream.of(aliases).map(c -> Alias.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAliases(Collection<Alias.BuilderImpl> aliases) {
            this.aliases = AliasListCopier.copyFromBuilder(aliases);
        }

        @Override
        public Edge build() {
            return new Edge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
