/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSamplingRuleResponse extends XRayResponse implements
        ToCopyableBuilder<DeleteSamplingRuleResponse.Builder, DeleteSamplingRuleResponse> {
    private static final SdkField<SamplingRuleRecord> SAMPLING_RULE_RECORD_FIELD = SdkField
            .<SamplingRuleRecord> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteSamplingRuleResponse::samplingRuleRecord)).setter(setter(Builder::samplingRuleRecord))
            .constructor(SamplingRuleRecord::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingRuleRecord").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLING_RULE_RECORD_FIELD));

    private final SamplingRuleRecord samplingRuleRecord;

    private DeleteSamplingRuleResponse(BuilderImpl builder) {
        super(builder);
        this.samplingRuleRecord = builder.samplingRuleRecord;
    }

    /**
     * <p>
     * The deleted rule definition and metadata.
     * </p>
     * 
     * @return The deleted rule definition and metadata.
     */
    public SamplingRuleRecord samplingRuleRecord() {
        return samplingRuleRecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(samplingRuleRecord());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSamplingRuleResponse)) {
            return false;
        }
        DeleteSamplingRuleResponse other = (DeleteSamplingRuleResponse) obj;
        return Objects.equals(samplingRuleRecord(), other.samplingRuleRecord());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteSamplingRuleResponse").add("SamplingRuleRecord", samplingRuleRecord()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SamplingRuleRecord":
            return Optional.ofNullable(clazz.cast(samplingRuleRecord()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSamplingRuleResponse, T> g) {
        return obj -> g.apply((DeleteSamplingRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSamplingRuleResponse> {
        /**
         * <p>
         * The deleted rule definition and metadata.
         * </p>
         * 
         * @param samplingRuleRecord
         *        The deleted rule definition and metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingRuleRecord(SamplingRuleRecord samplingRuleRecord);

        /**
         * <p>
         * The deleted rule definition and metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link SamplingRuleRecord.Builder} avoiding the need to
         * create one manually via {@link SamplingRuleRecord#builder()}.
         *
         * When the {@link Consumer} completes, {@link SamplingRuleRecord.Builder#build()} is called immediately and its
         * result is passed to {@link #samplingRuleRecord(SamplingRuleRecord)}.
         * 
         * @param samplingRuleRecord
         *        a consumer that will call methods on {@link SamplingRuleRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samplingRuleRecord(SamplingRuleRecord)
         */
        default Builder samplingRuleRecord(Consumer<SamplingRuleRecord.Builder> samplingRuleRecord) {
            return samplingRuleRecord(SamplingRuleRecord.builder().applyMutation(samplingRuleRecord).build());
        }
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private SamplingRuleRecord samplingRuleRecord;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSamplingRuleResponse model) {
            super(model);
            samplingRuleRecord(model.samplingRuleRecord);
        }

        public final SamplingRuleRecord.Builder getSamplingRuleRecord() {
            return samplingRuleRecord != null ? samplingRuleRecord.toBuilder() : null;
        }

        @Override
        public final Builder samplingRuleRecord(SamplingRuleRecord samplingRuleRecord) {
            this.samplingRuleRecord = samplingRuleRecord;
            return this;
        }

        public final void setSamplingRuleRecord(SamplingRuleRecord.BuilderImpl samplingRuleRecord) {
            this.samplingRuleRecord = samplingRuleRecord != null ? samplingRuleRecord.build() : null;
        }

        @Override
        public DeleteSamplingRuleResponse build() {
            return new DeleteSamplingRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
