/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Aggregated request sampling data for a sampling rule across all services for a 10 second window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamplingStatisticSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SamplingStatisticSummary.Builder, SamplingStatisticSummary> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SamplingStatisticSummary::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SamplingStatisticSummary::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<Integer> REQUEST_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SamplingStatisticSummary::requestCount)).setter(setter(Builder::requestCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestCount").build()).build();

    private static final SdkField<Integer> BORROW_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SamplingStatisticSummary::borrowCount)).setter(setter(Builder::borrowCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorrowCount").build()).build();

    private static final SdkField<Integer> SAMPLED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SamplingStatisticSummary::sampledCount)).setter(setter(Builder::sampledCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            TIMESTAMP_FIELD, REQUEST_COUNT_FIELD, BORROW_COUNT_FIELD, SAMPLED_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleName;

    private final Instant timestamp;

    private final Integer requestCount;

    private final Integer borrowCount;

    private final Integer sampledCount;

    private SamplingStatisticSummary(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.timestamp = builder.timestamp;
        this.requestCount = builder.requestCount;
        this.borrowCount = builder.borrowCount;
        this.sampledCount = builder.sampledCount;
    }

    /**
     * <p>
     * The name of the sampling rule.
     * </p>
     * 
     * @return The name of the sampling rule.
     */
    public String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The start time of the reporting window.
     * </p>
     * 
     * @return The start time of the reporting window.
     */
    public Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The number of requests that matched the rule.
     * </p>
     * 
     * @return The number of requests that matched the rule.
     */
    public Integer requestCount() {
        return requestCount;
    }

    /**
     * <p>
     * The number of requests recorded with borrowed reservoir quota.
     * </p>
     * 
     * @return The number of requests recorded with borrowed reservoir quota.
     */
    public Integer borrowCount() {
        return borrowCount;
    }

    /**
     * <p>
     * The number of requests recorded.
     * </p>
     * 
     * @return The number of requests recorded.
     */
    public Integer sampledCount() {
        return sampledCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(requestCount());
        hashCode = 31 * hashCode + Objects.hashCode(borrowCount());
        hashCode = 31 * hashCode + Objects.hashCode(sampledCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingStatisticSummary)) {
            return false;
        }
        SamplingStatisticSummary other = (SamplingStatisticSummary) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(requestCount(), other.requestCount()) && Objects.equals(borrowCount(), other.borrowCount())
                && Objects.equals(sampledCount(), other.sampledCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SamplingStatisticSummary").add("RuleName", ruleName()).add("Timestamp", timestamp())
                .add("RequestCount", requestCount()).add("BorrowCount", borrowCount()).add("SampledCount", sampledCount())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "RequestCount":
            return Optional.ofNullable(clazz.cast(requestCount()));
        case "BorrowCount":
            return Optional.ofNullable(clazz.cast(borrowCount()));
        case "SampledCount":
            return Optional.ofNullable(clazz.cast(sampledCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SamplingStatisticSummary, T> g) {
        return obj -> g.apply((SamplingStatisticSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamplingStatisticSummary> {
        /**
         * <p>
         * The name of the sampling rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the sampling rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The start time of the reporting window.
         * </p>
         * 
         * @param timestamp
         *        The start time of the reporting window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The number of requests that matched the rule.
         * </p>
         * 
         * @param requestCount
         *        The number of requests that matched the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestCount(Integer requestCount);

        /**
         * <p>
         * The number of requests recorded with borrowed reservoir quota.
         * </p>
         * 
         * @param borrowCount
         *        The number of requests recorded with borrowed reservoir quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder borrowCount(Integer borrowCount);

        /**
         * <p>
         * The number of requests recorded.
         * </p>
         * 
         * @param sampledCount
         *        The number of requests recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampledCount(Integer sampledCount);
    }

    static final class BuilderImpl implements Builder {
        private String ruleName;

        private Instant timestamp;

        private Integer requestCount;

        private Integer borrowCount;

        private Integer sampledCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingStatisticSummary model) {
            ruleName(model.ruleName);
            timestamp(model.timestamp);
            requestCount(model.requestCount);
            borrowCount(model.borrowCount);
            sampledCount(model.sampledCount);
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Integer getRequestCount() {
            return requestCount;
        }

        @Override
        public final Builder requestCount(Integer requestCount) {
            this.requestCount = requestCount;
            return this;
        }

        public final void setRequestCount(Integer requestCount) {
            this.requestCount = requestCount;
        }

        public final Integer getBorrowCount() {
            return borrowCount;
        }

        @Override
        public final Builder borrowCount(Integer borrowCount) {
            this.borrowCount = borrowCount;
            return this;
        }

        public final void setBorrowCount(Integer borrowCount) {
            this.borrowCount = borrowCount;
        }

        public final Integer getSampledCount() {
            return sampledCount;
        }

        @Override
        public final Builder sampledCount(Integer sampledCount) {
            this.sampledCount = sampledCount;
            return this;
        }

        public final void setSampledCount(Integer sampledCount) {
            this.sampledCount = sampledCount;
        }

        @Override
        public SamplingStatisticSummary build() {
            return new SamplingStatisticSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
