/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A document specifying changes to a sampling rule's configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamplingRuleUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<SamplingRuleUpdate.Builder, SamplingRuleUpdate> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SamplingRuleUpdate::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SamplingRuleUpdate::ruleARN)).setter(setter(Builder::ruleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleARN").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SamplingRuleUpdate::resourceARN)).setter(setter(Builder::resourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SamplingRuleUpdate::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<Double> FIXED_RATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(SamplingRuleUpdate::fixedRate)).setter(setter(Builder::fixedRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedRate").build()).build();

    private static final SdkField<Integer> RESERVOIR_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SamplingRuleUpdate::reservoirSize)).setter(setter(Builder::reservoirSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservoirSize").build()).build();

    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SamplingRuleUpdate::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SamplingRuleUpdate::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SamplingRuleUpdate::serviceType)).setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()).build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SamplingRuleUpdate::httpMethod)).setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPMethod").build()).build();

    private static final SdkField<String> URL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SamplingRuleUpdate::urlPath)).setter(setter(Builder::urlPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URLPath").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(SamplingRuleUpdate::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            RULE_ARN_FIELD, RESOURCE_ARN_FIELD, PRIORITY_FIELD, FIXED_RATE_FIELD, RESERVOIR_SIZE_FIELD, HOST_FIELD,
            SERVICE_NAME_FIELD, SERVICE_TYPE_FIELD, HTTP_METHOD_FIELD, URL_PATH_FIELD, ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleName;

    private final String ruleARN;

    private final String resourceARN;

    private final Integer priority;

    private final Double fixedRate;

    private final Integer reservoirSize;

    private final String host;

    private final String serviceName;

    private final String serviceType;

    private final String httpMethod;

    private final String urlPath;

    private final Map<String, String> attributes;

    private SamplingRuleUpdate(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.ruleARN = builder.ruleARN;
        this.resourceARN = builder.resourceARN;
        this.priority = builder.priority;
        this.fixedRate = builder.fixedRate;
        this.reservoirSize = builder.reservoirSize;
        this.host = builder.host;
        this.serviceName = builder.serviceName;
        this.serviceType = builder.serviceType;
        this.httpMethod = builder.httpMethod;
        this.urlPath = builder.urlPath;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The name of the sampling rule. Specify a rule by either name or ARN, but not both.
     * </p>
     * 
     * @return The name of the sampling rule. Specify a rule by either name or ARN, but not both.
     */
    public String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.
     * </p>
     * 
     * @return The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.
     */
    public String ruleARN() {
        return ruleARN;
    }

    /**
     * <p>
     * Matches the ARN of the AWS resource on which the service runs.
     * </p>
     * 
     * @return Matches the ARN of the AWS resource on which the service runs.
     */
    public String resourceARN() {
        return resourceARN;
    }

    /**
     * <p>
     * The priority of the sampling rule.
     * </p>
     * 
     * @return The priority of the sampling rule.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The percentage of matching requests to instrument, after the reservoir is exhausted.
     * </p>
     * 
     * @return The percentage of matching requests to instrument, after the reservoir is exhausted.
     */
    public Double fixedRate() {
        return fixedRate;
    }

    /**
     * <p>
     * A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is
     * not used directly by services, but applies to all services using the rule collectively.
     * </p>
     * 
     * @return A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The
     *         reservoir is not used directly by services, but applies to all services using the rule collectively.
     */
    public Integer reservoirSize() {
        return reservoirSize;
    }

    /**
     * <p>
     * Matches the hostname from a request URL.
     * </p>
     * 
     * @return Matches the hostname from a request URL.
     */
    public String host() {
        return host;
    }

    /**
     * <p>
     * Matches the <code>name</code> that the service uses to identify itself in segments.
     * </p>
     * 
     * @return Matches the <code>name</code> that the service uses to identify itself in segments.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * Matches the <code>origin</code> that the service uses to identify its type in segments.
     * </p>
     * 
     * @return Matches the <code>origin</code> that the service uses to identify its type in segments.
     */
    public String serviceType() {
        return serviceType;
    }

    /**
     * <p>
     * Matches the HTTP method of a request.
     * </p>
     * 
     * @return Matches the HTTP method of a request.
     */
    public String httpMethod() {
        return httpMethod;
    }

    /**
     * <p>
     * Matches the path from a request URL.
     * </p>
     * 
     * @return Matches the path from a request URL.
     */
    public String urlPath() {
        return urlPath;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Matches attributes derived from the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Matches attributes derived from the request.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleARN());
        hashCode = 31 * hashCode + Objects.hashCode(resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(fixedRate());
        hashCode = 31 * hashCode + Objects.hashCode(reservoirSize());
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceType());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(urlPath());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingRuleUpdate)) {
            return false;
        }
        SamplingRuleUpdate other = (SamplingRuleUpdate) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(ruleARN(), other.ruleARN())
                && Objects.equals(resourceARN(), other.resourceARN()) && Objects.equals(priority(), other.priority())
                && Objects.equals(fixedRate(), other.fixedRate()) && Objects.equals(reservoirSize(), other.reservoirSize())
                && Objects.equals(host(), other.host()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(serviceType(), other.serviceType()) && Objects.equals(httpMethod(), other.httpMethod())
                && Objects.equals(urlPath(), other.urlPath()) && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SamplingRuleUpdate").add("RuleName", ruleName()).add("RuleARN", ruleARN())
                .add("ResourceARN", resourceARN()).add("Priority", priority()).add("FixedRate", fixedRate())
                .add("ReservoirSize", reservoirSize()).add("Host", host()).add("ServiceName", serviceName())
                .add("ServiceType", serviceType()).add("HTTPMethod", httpMethod()).add("URLPath", urlPath())
                .add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "RuleARN":
            return Optional.ofNullable(clazz.cast(ruleARN()));
        case "ResourceARN":
            return Optional.ofNullable(clazz.cast(resourceARN()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "FixedRate":
            return Optional.ofNullable(clazz.cast(fixedRate()));
        case "ReservoirSize":
            return Optional.ofNullable(clazz.cast(reservoirSize()));
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceType()));
        case "HTTPMethod":
            return Optional.ofNullable(clazz.cast(httpMethod()));
        case "URLPath":
            return Optional.ofNullable(clazz.cast(urlPath()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SamplingRuleUpdate, T> g) {
        return obj -> g.apply((SamplingRuleUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamplingRuleUpdate> {
        /**
         * <p>
         * The name of the sampling rule. Specify a rule by either name or ARN, but not both.
         * </p>
         * 
         * @param ruleName
         *        The name of the sampling rule. Specify a rule by either name or ARN, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.
         * </p>
         * 
         * @param ruleARN
         *        The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleARN(String ruleARN);

        /**
         * <p>
         * Matches the ARN of the AWS resource on which the service runs.
         * </p>
         * 
         * @param resourceARN
         *        Matches the ARN of the AWS resource on which the service runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        /**
         * <p>
         * The priority of the sampling rule.
         * </p>
         * 
         * @param priority
         *        The priority of the sampling rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The percentage of matching requests to instrument, after the reservoir is exhausted.
         * </p>
         * 
         * @param fixedRate
         *        The percentage of matching requests to instrument, after the reservoir is exhausted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedRate(Double fixedRate);

        /**
         * <p>
         * A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir
         * is not used directly by services, but applies to all services using the rule collectively.
         * </p>
         * 
         * @param reservoirSize
         *        A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The
         *        reservoir is not used directly by services, but applies to all services using the rule collectively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservoirSize(Integer reservoirSize);

        /**
         * <p>
         * Matches the hostname from a request URL.
         * </p>
         * 
         * @param host
         *        Matches the hostname from a request URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * Matches the <code>name</code> that the service uses to identify itself in segments.
         * </p>
         * 
         * @param serviceName
         *        Matches the <code>name</code> that the service uses to identify itself in segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * Matches the <code>origin</code> that the service uses to identify its type in segments.
         * </p>
         * 
         * @param serviceType
         *        Matches the <code>origin</code> that the service uses to identify its type in segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * Matches the HTTP method of a request.
         * </p>
         * 
         * @param httpMethod
         *        Matches the HTTP method of a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * Matches the path from a request URL.
         * </p>
         * 
         * @param urlPath
         *        Matches the path from a request URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlPath(String urlPath);

        /**
         * <p>
         * Matches attributes derived from the request.
         * </p>
         * 
         * @param attributes
         *        Matches attributes derived from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl implements Builder {
        private String ruleName;

        private String ruleARN;

        private String resourceARN;

        private Integer priority;

        private Double fixedRate;

        private Integer reservoirSize;

        private String host;

        private String serviceName;

        private String serviceType;

        private String httpMethod;

        private String urlPath;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingRuleUpdate model) {
            ruleName(model.ruleName);
            ruleARN(model.ruleARN);
            resourceARN(model.resourceARN);
            priority(model.priority);
            fixedRate(model.fixedRate);
            reservoirSize(model.reservoirSize);
            host(model.host);
            serviceName(model.serviceName);
            serviceType(model.serviceType);
            httpMethod(model.httpMethod);
            urlPath(model.urlPath);
            attributes(model.attributes);
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getRuleARN() {
            return ruleARN;
        }

        @Override
        public final Builder ruleARN(String ruleARN) {
            this.ruleARN = ruleARN;
            return this;
        }

        public final void setRuleARN(String ruleARN) {
            this.ruleARN = ruleARN;
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Double getFixedRate() {
            return fixedRate;
        }

        @Override
        public final Builder fixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public final void setFixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
        }

        public final Integer getReservoirSize() {
            return reservoirSize;
        }

        @Override
        public final Builder reservoirSize(Integer reservoirSize) {
            this.reservoirSize = reservoirSize;
            return this;
        }

        public final void setReservoirSize(Integer reservoirSize) {
            this.reservoirSize = reservoirSize;
        }

        public final String getHost() {
            return host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getServiceType() {
            return serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getUrlPath() {
            return urlPath;
        }

        @Override
        public final Builder urlPath(String urlPath) {
            this.urlPath = urlPath;
            return this;
        }

        public final void setUrlPath(String urlPath) {
            this.urlPath = urlPath;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
        }

        @Override
        public SamplingRuleUpdate build() {
            return new SamplingRuleUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
