/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTraceGraphResponse extends XRayResponse implements
        ToCopyableBuilder<GetTraceGraphResponse.Builder, GetTraceGraphResponse> {
    private static final SdkField<List<Service>> SERVICES_FIELD = SdkField
            .<List<Service>> builder(MarshallingType.LIST)
            .getter(getter(GetTraceGraphResponse::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Service> builder(MarshallingType.SDK_POJO)
                                            .constructor(Service::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTraceGraphResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Service> services;

    private final String nextToken;

    private GetTraceGraphResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Services property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The services that have processed one of the specified requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The services that have processed one of the specified requests.
     */
    public List<Service> services() {
        return services;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(services());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceGraphResponse)) {
            return false;
        }
        GetTraceGraphResponse other = (GetTraceGraphResponse) obj;
        return Objects.equals(services(), other.services()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetTraceGraphResponse").add("Services", services()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Services":
            return Optional.ofNullable(clazz.cast(services()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTraceGraphResponse, T> g) {
        return obj -> g.apply((GetTraceGraphResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTraceGraphResponse> {
        /**
         * <p>
         * The services that have processed one of the specified requests.
         * </p>
         * 
         * @param services
         *        The services that have processed one of the specified requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<Service> services);

        /**
         * <p>
         * The services that have processed one of the specified requests.
         * </p>
         * 
         * @param services
         *        The services that have processed one of the specified requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Service... services);

        /**
         * <p>
         * The services that have processed one of the specified requests.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Service>.Builder} avoiding the need to
         * create one manually via {@link List<Service>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Service>.Builder#build()} is called immediately and its
         * result is passed to {@link #services(List<Service>)}.
         * 
         * @param services
         *        a consumer that will call methods on {@link List<Service>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #services(List<Service>)
         */
        Builder services(Consumer<Service.Builder>... services);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private List<Service> services = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTraceGraphResponse model) {
            super(model);
            services(model.services);
            nextToken(model.nextToken);
        }

        public final Collection<Service.Builder> getServices() {
            return services != null ? services.stream().map(Service::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Service... services) {
            services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<Service.Builder>... services) {
            services(Stream.of(services).map(c -> Service.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServices(Collection<Service.BuilderImpl> services) {
            this.services = ServiceListCopier.copyFromBuilder(services);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTraceGraphResponse build() {
            return new GetTraceGraphResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
