/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetTracesRequest extends XRayRequest implements
        ToCopyableBuilder<BatchGetTracesRequest.Builder, BatchGetTracesRequest> {
    private static final SdkField<List<String>> TRACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetTracesRequest::traceIds))
            .setter(setter(Builder::traceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchGetTracesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> traceIds;

    private final String nextToken;

    private BatchGetTracesRequest(BuilderImpl builder) {
        super(builder);
        this.traceIds = builder.traceIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TraceIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTraceIds() {
        return traceIds != null && !(traceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the trace IDs of requests for which to retrieve segments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTraceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specify the trace IDs of requests for which to retrieve segments.
     */
    public List<String> traceIds() {
        return traceIds;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(traceIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTracesRequest)) {
            return false;
        }
        BatchGetTracesRequest other = (BatchGetTracesRequest) obj;
        return Objects.equals(traceIds(), other.traceIds()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetTracesRequest").add("TraceIds", traceIds()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TraceIds":
            return Optional.ofNullable(clazz.cast(traceIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTracesRequest, T> g) {
        return obj -> g.apply((BatchGetTracesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetTracesRequest> {
        /**
         * <p>
         * Specify the trace IDs of requests for which to retrieve segments.
         * </p>
         * 
         * @param traceIds
         *        Specify the trace IDs of requests for which to retrieve segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceIds(Collection<String> traceIds);

        /**
         * <p>
         * Specify the trace IDs of requests for which to retrieve segments.
         * </p>
         * 
         * @param traceIds
         *        Specify the trace IDs of requests for which to retrieve segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceIds(String... traceIds);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private List<String> traceIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTracesRequest model) {
            super(model);
            traceIds(model.traceIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getTraceIds() {
            return traceIds;
        }

        @Override
        public final Builder traceIds(Collection<String> traceIds) {
            this.traceIds = TraceIdListCopier.copy(traceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traceIds(String... traceIds) {
            traceIds(Arrays.asList(traceIds));
            return this;
        }

        public final void setTraceIds(Collection<String> traceIds) {
            this.traceIds = TraceIdListCopier.copy(traceIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetTracesRequest build() {
            return new BatchGetTracesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
