/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.xray.model.AttributeMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamplingRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SamplingRule> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SamplingRule.getter(SamplingRule::ruleName)).setter(SamplingRule.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SamplingRule.getter(SamplingRule::ruleARN)).setter(SamplingRule.setter(Builder::ruleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleARN").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SamplingRule.getter(SamplingRule::resourceARN)).setter(SamplingRule.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SamplingRule.getter(SamplingRule::priority)).setter(SamplingRule.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<Double> FIXED_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(SamplingRule.getter(SamplingRule::fixedRate)).setter(SamplingRule.setter(Builder::fixedRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedRate").build()}).build();
    private static final SdkField<Integer> RESERVOIR_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SamplingRule.getter(SamplingRule::reservoirSize)).setter(SamplingRule.setter(Builder::reservoirSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservoirSize").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SamplingRule.getter(SamplingRule::serviceName)).setter(SamplingRule.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SamplingRule.getter(SamplingRule::serviceType)).setter(SamplingRule.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()}).build();
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SamplingRule.getter(SamplingRule::host)).setter(SamplingRule.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()}).build();
    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SamplingRule.getter(SamplingRule::httpMethod)).setter(SamplingRule.setter(Builder::httpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPMethod").build()}).build();
    private static final SdkField<String> URL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SamplingRule.getter(SamplingRule::urlPath)).setter(SamplingRule.setter(Builder::urlPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URLPath").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SamplingRule.getter(SamplingRule::version)).setter(SamplingRule.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(SamplingRule.getter(SamplingRule::attributes)).setter(SamplingRule.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, RULE_ARN_FIELD, RESOURCE_ARN_FIELD, PRIORITY_FIELD, FIXED_RATE_FIELD, RESERVOIR_SIZE_FIELD, SERVICE_NAME_FIELD, SERVICE_TYPE_FIELD, HOST_FIELD, HTTP_METHOD_FIELD, URL_PATH_FIELD, VERSION_FIELD, ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleName;
    private final String ruleARN;
    private final String resourceARN;
    private final Integer priority;
    private final Double fixedRate;
    private final Integer reservoirSize;
    private final String serviceName;
    private final String serviceType;
    private final String host;
    private final String httpMethod;
    private final String urlPath;
    private final Integer version;
    private final Map<String, String> attributes;

    private SamplingRule(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.ruleARN = builder.ruleARN;
        this.resourceARN = builder.resourceARN;
        this.priority = builder.priority;
        this.fixedRate = builder.fixedRate;
        this.reservoirSize = builder.reservoirSize;
        this.serviceName = builder.serviceName;
        this.serviceType = builder.serviceType;
        this.host = builder.host;
        this.httpMethod = builder.httpMethod;
        this.urlPath = builder.urlPath;
        this.version = builder.version;
        this.attributes = builder.attributes;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public String ruleARN() {
        return this.ruleARN;
    }

    public String resourceARN() {
        return this.resourceARN;
    }

    public Integer priority() {
        return this.priority;
    }

    public Double fixedRate() {
        return this.fixedRate;
    }

    public Integer reservoirSize() {
        return this.reservoirSize;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String serviceType() {
        return this.serviceType;
    }

    public String host() {
        return this.host;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public String urlPath() {
        return this.urlPath;
    }

    public Integer version() {
        return this.version;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservoirSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingRule)) {
            return false;
        }
        SamplingRule other = (SamplingRule)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.ruleARN(), other.ruleARN()) && Objects.equals(this.resourceARN(), other.resourceARN()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.fixedRate(), other.fixedRate()) && Objects.equals(this.reservoirSize(), other.reservoirSize()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceType(), other.serviceType()) && Objects.equals(this.host(), other.host()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.urlPath(), other.urlPath()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"SamplingRule").add("RuleName", (Object)this.ruleName()).add("RuleARN", (Object)this.ruleARN()).add("ResourceARN", (Object)this.resourceARN()).add("Priority", (Object)this.priority()).add("FixedRate", (Object)this.fixedRate()).add("ReservoirSize", (Object)this.reservoirSize()).add("ServiceName", (Object)this.serviceName()).add("ServiceType", (Object)this.serviceType()).add("Host", (Object)this.host()).add("HTTPMethod", (Object)this.httpMethod()).add("URLPath", (Object)this.urlPath()).add("Version", (Object)this.version()).add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "RuleARN": {
                return Optional.ofNullable(clazz.cast(this.ruleARN()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "FixedRate": {
                return Optional.ofNullable(clazz.cast(this.fixedRate()));
            }
            case "ReservoirSize": {
                return Optional.ofNullable(clazz.cast(this.reservoirSize()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceType()));
            }
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "HTTPMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "URLPath": {
                return Optional.ofNullable(clazz.cast(this.urlPath()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SamplingRule, T> g) {
        return obj -> g.apply((SamplingRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private String ruleARN;
        private String resourceARN;
        private Integer priority;
        private Double fixedRate;
        private Integer reservoirSize;
        private String serviceName;
        private String serviceType;
        private String host;
        private String httpMethod;
        private String urlPath;
        private Integer version;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingRule model) {
            this.ruleName(model.ruleName);
            this.ruleARN(model.ruleARN);
            this.resourceARN(model.resourceARN);
            this.priority(model.priority);
            this.fixedRate(model.fixedRate);
            this.reservoirSize(model.reservoirSize);
            this.serviceName(model.serviceName);
            this.serviceType(model.serviceType);
            this.host(model.host);
            this.httpMethod(model.httpMethod);
            this.urlPath(model.urlPath);
            this.version(model.version);
            this.attributes(model.attributes);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getRuleARN() {
            return this.ruleARN;
        }

        @Override
        public final Builder ruleARN(String ruleARN) {
            this.ruleARN = ruleARN;
            return this;
        }

        public final void setRuleARN(String ruleARN) {
            this.ruleARN = ruleARN;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Double getFixedRate() {
            return this.fixedRate;
        }

        @Override
        public final Builder fixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public final void setFixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
        }

        public final Integer getReservoirSize() {
            return this.reservoirSize;
        }

        @Override
        public final Builder reservoirSize(Integer reservoirSize) {
            this.reservoirSize = reservoirSize;
            return this;
        }

        public final void setReservoirSize(Integer reservoirSize) {
            this.reservoirSize = reservoirSize;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public final String getHost() {
            return this.host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        public final String getHTTPMethod() {
            return this.httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHTTPMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getURLPath() {
            return this.urlPath;
        }

        @Override
        public final Builder urlPath(String urlPath) {
            this.urlPath = urlPath;
            return this;
        }

        public final void setURLPath(String urlPath) {
            this.urlPath = urlPath;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
        }

        public SamplingRule build() {
            return new SamplingRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SamplingRule> {
        public Builder ruleName(String var1);

        public Builder ruleARN(String var1);

        public Builder resourceARN(String var1);

        public Builder priority(Integer var1);

        public Builder fixedRate(Double var1);

        public Builder reservoirSize(Integer var1);

        public Builder serviceName(String var1);

        public Builder serviceType(String var1);

        public Builder host(String var1);

        public Builder httpMethod(String var1);

        public Builder urlPath(String var1);

        public Builder version(Integer var1);

        public Builder attributes(Map<String, String> var1);
    }
}

