/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.Segment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SegmentMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Document").isBinary(false).build();
    private static final SegmentMarshaller INSTANCE = new SegmentMarshaller();

    private SegmentMarshaller() {
    }

    public static SegmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Segment segment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)segment, (String)"segment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)segment.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)segment.document(), DOCUMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

