/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.xray.model.TraceSummary;
import software.amazon.awssdk.services.xray.model.TraceSummaryListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTraceSummariesResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetTraceSummariesResponse> {
    private final List<TraceSummary> traceSummaries;
    private final Instant approximateTime;
    private final Long tracesProcessedCount;
    private final String nextToken;

    private GetTraceSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.traceSummaries = builder.traceSummaries;
        this.approximateTime = builder.approximateTime;
        this.tracesProcessedCount = builder.tracesProcessedCount;
        this.nextToken = builder.nextToken;
    }

    public List<TraceSummary> traceSummaries() {
        return this.traceSummaries;
    }

    public Instant approximateTime() {
        return this.approximateTime;
    }

    public Long tracesProcessedCount() {
        return this.tracesProcessedCount;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.traceSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracesProcessedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceSummariesResponse)) {
            return false;
        }
        GetTraceSummariesResponse other = (GetTraceSummariesResponse)((Object)obj);
        return Objects.equals(this.traceSummaries(), other.traceSummaries()) && Objects.equals(this.approximateTime(), other.approximateTime()) && Objects.equals(this.tracesProcessedCount(), other.tracesProcessedCount()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetTraceSummariesResponse").add("TraceSummaries", this.traceSummaries()).add("ApproximateTime", (Object)this.approximateTime()).add("TracesProcessedCount", (Object)this.tracesProcessedCount()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TraceSummaries": {
                return Optional.of(clazz.cast(this.traceSummaries()));
            }
            case "ApproximateTime": {
                return Optional.of(clazz.cast(this.approximateTime()));
            }
            case "TracesProcessedCount": {
                return Optional.of(clazz.cast(this.tracesProcessedCount()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<TraceSummary> traceSummaries;
        private Instant approximateTime;
        private Long tracesProcessedCount;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTraceSummariesResponse model) {
            this.traceSummaries(model.traceSummaries);
            this.approximateTime(model.approximateTime);
            this.tracesProcessedCount(model.tracesProcessedCount);
            this.nextToken(model.nextToken);
        }

        public final Collection<TraceSummary.Builder> getTraceSummaries() {
            return this.traceSummaries != null ? (Collection)this.traceSummaries.stream().map(TraceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder traceSummaries(Collection<TraceSummary> traceSummaries) {
            this.traceSummaries = TraceSummaryListCopier.copy(traceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traceSummaries(TraceSummary ... traceSummaries) {
            this.traceSummaries(Arrays.asList(traceSummaries));
            return this;
        }

        public final void setTraceSummaries(Collection<TraceSummary.BuilderImpl> traceSummaries) {
            this.traceSummaries = TraceSummaryListCopier.copyFromBuilder(traceSummaries);
        }

        public final Instant getApproximateTime() {
            return this.approximateTime;
        }

        @Override
        public final Builder approximateTime(Instant approximateTime) {
            this.approximateTime = approximateTime;
            return this;
        }

        public final void setApproximateTime(Instant approximateTime) {
            this.approximateTime = approximateTime;
        }

        public final Long getTracesProcessedCount() {
            return this.tracesProcessedCount;
        }

        @Override
        public final Builder tracesProcessedCount(Long tracesProcessedCount) {
            this.tracesProcessedCount = tracesProcessedCount;
            return this;
        }

        public final void setTracesProcessedCount(Long tracesProcessedCount) {
            this.tracesProcessedCount = tracesProcessedCount;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTraceSummariesResponse build() {
            return new GetTraceSummariesResponse(this);
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    CopyableBuilder<Builder, GetTraceSummariesResponse> {
        public Builder traceSummaries(Collection<TraceSummary> var1);

        public Builder traceSummaries(TraceSummary ... var1);

        public Builder approximateTime(Instant var1);

        public Builder tracesProcessedCount(Long var1);

        public Builder nextToken(String var1);
    }
}

