/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.Segment;
import software.amazon.awssdk.services.xray.model.SegmentListCopier;
import software.amazon.awssdk.services.xray.transform.TraceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Trace
implements StructuredPojo,
ToCopyableBuilder<Builder, Trace> {
    private final String id;
    private final Double duration;
    private final List<Segment> segments;

    private Trace(BuilderImpl builder) {
        this.id = builder.id;
        this.duration = builder.duration;
        this.segments = builder.segments;
    }

    public String id() {
        return this.id;
    }

    public Double duration() {
        return this.duration;
    }

    public List<Segment> segments() {
        return this.segments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.segments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trace)) {
            return false;
        }
        Trace other = (Trace)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.segments(), other.segments());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.segments() != null) {
            sb.append("Segments: ").append(this.segments()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Duration": {
                return Optional.of(clazz.cast(this.duration()));
            }
            case "Segments": {
                return Optional.of(clazz.cast(this.segments()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TraceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Double duration;
        private List<Segment> segments;

        private BuilderImpl() {
        }

        private BuilderImpl(Trace model) {
            this.id(model.id);
            this.duration(model.duration);
            this.segments(model.segments);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Double getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        public final Collection<Segment.Builder> getSegments() {
            return this.segments != null ? (Collection)this.segments.stream().map(Segment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder segments(Collection<Segment> segments) {
            this.segments = SegmentListCopier.copy(segments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(Segment ... segments) {
            this.segments(Arrays.asList(segments));
            return this;
        }

        public final void setSegments(Collection<Segment.BuilderImpl> segments) {
            this.segments = SegmentListCopier.copyFromBuilder(segments);
        }

        public Trace build() {
            return new Trace(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Trace> {
        public Builder id(String var1);

        public Builder duration(Double var1);

        public Builder segments(Collection<Segment> var1);

        public Builder segments(Segment ... var1);
    }
}

