/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray;

import java.util.function.Consumer;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.xray.DefaultXRayClientBuilder;
import software.amazon.awssdk.services.xray.XRayClientBuilder;
import software.amazon.awssdk.services.xray.model.BatchGetTracesRequest;
import software.amazon.awssdk.services.xray.model.BatchGetTracesResponse;
import software.amazon.awssdk.services.xray.model.GetServiceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetServiceGraphResponse;
import software.amazon.awssdk.services.xray.model.GetTraceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetTraceGraphResponse;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse;
import software.amazon.awssdk.services.xray.model.InvalidRequestException;
import software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest;
import software.amazon.awssdk.services.xray.model.PutTelemetryRecordsResponse;
import software.amazon.awssdk.services.xray.model.PutTraceSegmentsRequest;
import software.amazon.awssdk.services.xray.model.PutTraceSegmentsResponse;
import software.amazon.awssdk.services.xray.model.ThrottledException;
import software.amazon.awssdk.services.xray.model.XRayException;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface XRayClient
extends SdkAutoCloseable {
    public static final String SERVICE_NAME = "xray";

    public static XRayClient create() {
        return (XRayClient)XRayClient.builder().build();
    }

    public static XRayClientBuilder builder() {
        return new DefaultXRayClientBuilder();
    }

    default public BatchGetTracesResponse batchGetTraces(BatchGetTracesRequest batchGetTracesRequest) throws InvalidRequestException, ThrottledException, SdkServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    default public BatchGetTracesResponse batchGetTraces(Consumer<BatchGetTracesRequest.Builder> batchGetTracesRequest) throws InvalidRequestException, ThrottledException, SdkServiceException, SdkClientException, XRayException {
        return this.batchGetTraces((BatchGetTracesRequest)((Object)((BatchGetTracesRequest.Builder)BatchGetTracesRequest.builder().apply(batchGetTracesRequest)).build()));
    }

    default public GetServiceGraphResponse getServiceGraph(GetServiceGraphRequest getServiceGraphRequest) throws InvalidRequestException, ThrottledException, SdkServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    default public GetServiceGraphResponse getServiceGraph(Consumer<GetServiceGraphRequest.Builder> getServiceGraphRequest) throws InvalidRequestException, ThrottledException, SdkServiceException, SdkClientException, XRayException {
        return this.getServiceGraph((GetServiceGraphRequest)((Object)((GetServiceGraphRequest.Builder)GetServiceGraphRequest.builder().apply(getServiceGraphRequest)).build()));
    }

    default public GetTraceGraphResponse getTraceGraph(GetTraceGraphRequest getTraceGraphRequest) throws InvalidRequestException, ThrottledException, SdkServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    default public GetTraceGraphResponse getTraceGraph(Consumer<GetTraceGraphRequest.Builder> getTraceGraphRequest) throws InvalidRequestException, ThrottledException, SdkServiceException, SdkClientException, XRayException {
        return this.getTraceGraph((GetTraceGraphRequest)((Object)((GetTraceGraphRequest.Builder)GetTraceGraphRequest.builder().apply(getTraceGraphRequest)).build()));
    }

    default public GetTraceSummariesResponse getTraceSummaries(GetTraceSummariesRequest getTraceSummariesRequest) throws InvalidRequestException, ThrottledException, SdkServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    default public GetTraceSummariesResponse getTraceSummaries(Consumer<GetTraceSummariesRequest.Builder> getTraceSummariesRequest) throws InvalidRequestException, ThrottledException, SdkServiceException, SdkClientException, XRayException {
        return this.getTraceSummaries((GetTraceSummariesRequest)((Object)((GetTraceSummariesRequest.Builder)GetTraceSummariesRequest.builder().apply(getTraceSummariesRequest)).build()));
    }

    default public PutTelemetryRecordsResponse putTelemetryRecords(PutTelemetryRecordsRequest putTelemetryRecordsRequest) throws InvalidRequestException, ThrottledException, SdkServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    default public PutTelemetryRecordsResponse putTelemetryRecords(Consumer<PutTelemetryRecordsRequest.Builder> putTelemetryRecordsRequest) throws InvalidRequestException, ThrottledException, SdkServiceException, SdkClientException, XRayException {
        return this.putTelemetryRecords((PutTelemetryRecordsRequest)((Object)((PutTelemetryRecordsRequest.Builder)PutTelemetryRecordsRequest.builder().apply(putTelemetryRecordsRequest)).build()));
    }

    default public PutTraceSegmentsResponse putTraceSegments(PutTraceSegmentsRequest putTraceSegmentsRequest) throws InvalidRequestException, ThrottledException, SdkServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    default public PutTraceSegmentsResponse putTraceSegments(Consumer<PutTraceSegmentsRequest.Builder> putTraceSegmentsRequest) throws InvalidRequestException, ThrottledException, SdkServiceException, SdkClientException, XRayException {
        return this.putTraceSegments((PutTraceSegmentsRequest)((Object)((PutTraceSegmentsRequest.Builder)PutTraceSegmentsRequest.builder().apply(putTraceSegmentsRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

