/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.TraceUser;
import software.amazon.awssdk.services.xray.transform.ServiceIdUnmarshaller;

public class TraceUserUnmarshaller
implements Unmarshaller<TraceUser, JsonUnmarshallerContext> {
    private static final TraceUserUnmarshaller INSTANCE = new TraceUserUnmarshaller();

    public TraceUser unmarshall(JsonUnmarshallerContext context) throws Exception {
        TraceUser.Builder traceUserBuilder = TraceUser.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("UserName", targetDepth)) {
                    context.nextToken();
                    traceUserBuilder.userName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ServiceIds", targetDepth)) {
                    context.nextToken();
                    traceUserBuilder.serviceIds(new ListUnmarshaller((Unmarshaller)ServiceIdUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TraceUser)traceUserBuilder.build();
    }

    public static TraceUserUnmarshaller getInstance() {
        return INSTANCE;
    }
}

