/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest;

@SdkInternalApi
public class GetTraceSummariesRequestModelMarshaller {
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").build();
    private static final MarshallingInfo<Boolean> SAMPLING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sampling").build();
    private static final MarshallingInfo<String> FILTEREXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FilterExpression").build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").build();
    private static final GetTraceSummariesRequestModelMarshaller INSTANCE = new GetTraceSummariesRequestModelMarshaller();

    public static GetTraceSummariesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetTraceSummariesRequest getTraceSummariesRequest, ProtocolMarshaller protocolMarshaller) {
        if (getTraceSummariesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)getTraceSummariesRequest.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)getTraceSummariesRequest.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)getTraceSummariesRequest.sampling(), SAMPLING_BINDING);
            protocolMarshaller.marshall((Object)getTraceSummariesRequest.filterExpression(), FILTEREXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)getTraceSummariesRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

