/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.Alias;
import software.amazon.awssdk.services.xray.model.AliasListCopier;
import software.amazon.awssdk.services.xray.model.EdgeStatistics;
import software.amazon.awssdk.services.xray.model.HistogramCopier;
import software.amazon.awssdk.services.xray.model.HistogramEntry;
import software.amazon.awssdk.services.xray.transform.EdgeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Edge
implements StructuredPojo,
ToCopyableBuilder<Builder, Edge> {
    private final Integer referenceId;
    private final Instant startTime;
    private final Instant endTime;
    private final EdgeStatistics summaryStatistics;
    private final List<HistogramEntry> responseTimeHistogram;
    private final List<Alias> aliases;

    private Edge(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.summaryStatistics = builder.summaryStatistics;
        this.responseTimeHistogram = builder.responseTimeHistogram;
        this.aliases = builder.aliases;
    }

    public Integer referenceId() {
        return this.referenceId;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public EdgeStatistics summaryStatistics() {
        return this.summaryStatistics;
    }

    public List<HistogramEntry> responseTimeHistogram() {
        return this.responseTimeHistogram;
    }

    public List<Alias> aliases() {
        return this.aliases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.referenceId() == null ? 0 : this.referenceId().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.summaryStatistics() == null ? 0 : this.summaryStatistics().hashCode());
        hashCode = 31 * hashCode + (this.responseTimeHistogram() == null ? 0 : this.responseTimeHistogram().hashCode());
        hashCode = 31 * hashCode + (this.aliases() == null ? 0 : this.aliases().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)obj;
        if (other.referenceId() == null ^ this.referenceId() == null) {
            return false;
        }
        if (other.referenceId() != null && !other.referenceId().equals(this.referenceId())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.summaryStatistics() == null ^ this.summaryStatistics() == null) {
            return false;
        }
        if (other.summaryStatistics() != null && !other.summaryStatistics().equals(this.summaryStatistics())) {
            return false;
        }
        if (other.responseTimeHistogram() == null ^ this.responseTimeHistogram() == null) {
            return false;
        }
        if (other.responseTimeHistogram() != null && !other.responseTimeHistogram().equals(this.responseTimeHistogram())) {
            return false;
        }
        if (other.aliases() == null ^ this.aliases() == null) {
            return false;
        }
        return other.aliases() == null || other.aliases().equals(this.aliases());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.referenceId() != null) {
            sb.append("ReferenceId: ").append(this.referenceId()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.summaryStatistics() != null) {
            sb.append("SummaryStatistics: ").append(this.summaryStatistics()).append(",");
        }
        if (this.responseTimeHistogram() != null) {
            sb.append("ResponseTimeHistogram: ").append(this.responseTimeHistogram()).append(",");
        }
        if (this.aliases() != null) {
            sb.append("Aliases: ").append(this.aliases()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReferenceId": {
                return Optional.of(clazz.cast(this.referenceId()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "SummaryStatistics": {
                return Optional.of(clazz.cast(this.summaryStatistics()));
            }
            case "ResponseTimeHistogram": {
                return Optional.of(clazz.cast(this.responseTimeHistogram()));
            }
            case "Aliases": {
                return Optional.of(clazz.cast(this.aliases()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EdgeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer referenceId;
        private Instant startTime;
        private Instant endTime;
        private EdgeStatistics summaryStatistics;
        private List<HistogramEntry> responseTimeHistogram;
        private List<Alias> aliases;

        private BuilderImpl() {
        }

        private BuilderImpl(Edge model) {
            this.referenceId(model.referenceId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.summaryStatistics(model.summaryStatistics);
            this.responseTimeHistogram(model.responseTimeHistogram);
            this.aliases(model.aliases);
        }

        public final Integer getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(Integer referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(Integer referenceId) {
            this.referenceId = referenceId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final EdgeStatistics.Builder getSummaryStatistics() {
            return this.summaryStatistics != null ? this.summaryStatistics.toBuilder() : null;
        }

        @Override
        public final Builder summaryStatistics(EdgeStatistics summaryStatistics) {
            this.summaryStatistics = summaryStatistics;
            return this;
        }

        public final void setSummaryStatistics(EdgeStatistics.BuilderImpl summaryStatistics) {
            this.summaryStatistics = summaryStatistics != null ? summaryStatistics.build() : null;
        }

        public final Collection<HistogramEntry.Builder> getResponseTimeHistogram() {
            return this.responseTimeHistogram != null ? (Collection)this.responseTimeHistogram.stream().map(HistogramEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copy(responseTimeHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(HistogramEntry ... responseTimeHistogram) {
            this.responseTimeHistogram(Arrays.asList(responseTimeHistogram));
            return this;
        }

        public final void setResponseTimeHistogram(Collection<HistogramEntry.BuilderImpl> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copyFromBuilder(responseTimeHistogram);
        }

        public final Collection<Alias.Builder> getAliases() {
            return this.aliases != null ? (Collection)this.aliases.stream().map(Alias::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aliases(Collection<Alias> aliases) {
            this.aliases = AliasListCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Alias ... aliases) {
            this.aliases(Arrays.asList(aliases));
            return this;
        }

        public final void setAliases(Collection<Alias.BuilderImpl> aliases) {
            this.aliases = AliasListCopier.copyFromBuilder(aliases);
        }

        public Edge build() {
            return new Edge(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Edge> {
        public Builder referenceId(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder summaryStatistics(EdgeStatistics var1);

        public Builder responseTimeHistogram(Collection<HistogramEntry> var1);

        public Builder responseTimeHistogram(HistogramEntry ... var1);

        public Builder aliases(Collection<Alias> var1);

        public Builder aliases(Alias ... var1);
    }
}

