/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.TraceSummary;
import software.amazon.awssdk.services.xray.transform.HttpUnmarshaller;
import software.amazon.awssdk.services.xray.transform.ServiceIdUnmarshaller;
import software.amazon.awssdk.services.xray.transform.TraceUserUnmarshaller;
import software.amazon.awssdk.services.xray.transform.ValueWithServiceIdsUnmarshaller;

public class TraceSummaryUnmarshaller
implements Unmarshaller<TraceSummary, JsonUnmarshallerContext> {
    private static final TraceSummaryUnmarshaller INSTANCE = new TraceSummaryUnmarshaller();

    public TraceSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        TraceSummary.Builder traceSummaryBuilder = TraceSummary.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    traceSummaryBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Duration", targetDepth)) {
                    context.nextToken();
                    traceSummaryBuilder.duration((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResponseTime", targetDepth)) {
                    context.nextToken();
                    traceSummaryBuilder.responseTime((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("HasFault", targetDepth)) {
                    context.nextToken();
                    traceSummaryBuilder.hasFault((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("HasError", targetDepth)) {
                    context.nextToken();
                    traceSummaryBuilder.hasError((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("HasThrottle", targetDepth)) {
                    context.nextToken();
                    traceSummaryBuilder.hasThrottle((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("IsPartial", targetDepth)) {
                    context.nextToken();
                    traceSummaryBuilder.isPartial((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("Http", targetDepth)) {
                    context.nextToken();
                    traceSummaryBuilder.http(HttpUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Annotations", targetDepth)) {
                    context.nextToken();
                    traceSummaryBuilder.annotations(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller((Unmarshaller)ValueWithServiceIdsUnmarshaller.getInstance())).unmarshall(context));
                }
                if (context.testExpression("Users", targetDepth)) {
                    context.nextToken();
                    traceSummaryBuilder.users(new ListUnmarshaller((Unmarshaller)TraceUserUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ServiceIds", targetDepth)) {
                    context.nextToken();
                    traceSummaryBuilder.serviceIds(new ListUnmarshaller((Unmarshaller)ServiceIdUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TraceSummary)traceSummaryBuilder.build();
    }

    public static TraceSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

