/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.ErrorStatistics;

public class ErrorStatisticsUnmarshaller
implements Unmarshaller<ErrorStatistics, JsonUnmarshallerContext> {
    private static final ErrorStatisticsUnmarshaller INSTANCE = new ErrorStatisticsUnmarshaller();

    public ErrorStatistics unmarshall(JsonUnmarshallerContext context) throws Exception {
        ErrorStatistics.Builder errorStatisticsBuilder = ErrorStatistics.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ThrottleCount", targetDepth)) {
                    context.nextToken();
                    errorStatisticsBuilder.throttleCount((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("OtherCount", targetDepth)) {
                    context.nextToken();
                    errorStatisticsBuilder.otherCount((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("TotalCount", targetDepth)) {
                    context.nextToken();
                    errorStatisticsBuilder.totalCount((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ErrorStatistics)errorStatisticsBuilder.build();
    }

    public static ErrorStatisticsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

