/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.transform.SegmentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Segment
implements StructuredPojo,
ToCopyableBuilder<Builder, Segment> {
    private final String id;
    private final String document;

    private Segment(BuilderImpl builder) {
        this.id = builder.id;
        this.document = builder.document;
    }

    public String id() {
        return this.id;
    }

    public String document() {
        return this.document;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.document() == null ? 0 : this.document().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Segment)) {
            return false;
        }
        Segment other = (Segment)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.document() == null ^ this.document() == null) {
            return false;
        }
        return other.document() == null || other.document().equals(this.document());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.document() != null) {
            sb.append("Document: ").append(this.document()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String document;

        private BuilderImpl() {
        }

        private BuilderImpl(Segment model) {
            this.setId(model.id);
            this.setDocument(model.document);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDocument() {
            return this.document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public Segment build() {
            return new Segment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Segment> {
        public Builder id(String var1);

        public Builder document(String var1);
    }
}

