/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.xray.model.TraceSegmentDocumentListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutTraceSegmentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutTraceSegmentsRequest> {
    private final List<String> traceSegmentDocuments;

    private PutTraceSegmentsRequest(BuilderImpl builder) {
        this.traceSegmentDocuments = builder.traceSegmentDocuments;
    }

    public List<String> traceSegmentDocuments() {
        return this.traceSegmentDocuments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.traceSegmentDocuments() == null ? 0 : this.traceSegmentDocuments().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTraceSegmentsRequest)) {
            return false;
        }
        PutTraceSegmentsRequest other = (PutTraceSegmentsRequest)((Object)obj);
        if (other.traceSegmentDocuments() == null ^ this.traceSegmentDocuments() == null) {
            return false;
        }
        return other.traceSegmentDocuments() == null || other.traceSegmentDocuments().equals(this.traceSegmentDocuments());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.traceSegmentDocuments() != null) {
            sb.append("TraceSegmentDocuments: ").append(this.traceSegmentDocuments()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> traceSegmentDocuments;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTraceSegmentsRequest model) {
            this.setTraceSegmentDocuments(model.traceSegmentDocuments);
        }

        public final Collection<String> getTraceSegmentDocuments() {
            return this.traceSegmentDocuments;
        }

        @Override
        public final Builder traceSegmentDocuments(Collection<String> traceSegmentDocuments) {
            this.traceSegmentDocuments = TraceSegmentDocumentListCopier.copy(traceSegmentDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traceSegmentDocuments(String ... traceSegmentDocuments) {
            this.traceSegmentDocuments(Arrays.asList(traceSegmentDocuments));
            return this;
        }

        public final void setTraceSegmentDocuments(Collection<String> traceSegmentDocuments) {
            this.traceSegmentDocuments = TraceSegmentDocumentListCopier.copy(traceSegmentDocuments);
        }

        public PutTraceSegmentsRequest build() {
            return new PutTraceSegmentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutTraceSegmentsRequest> {
        public Builder traceSegmentDocuments(Collection<String> var1);

        public Builder traceSegmentDocuments(String ... var1);
    }
}

