/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.xray.model.TraceIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTraceGraphRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetTraceGraphRequest> {
    private final List<String> traceIds;
    private final String nextToken;

    private GetTraceGraphRequest(BuilderImpl builder) {
        this.traceIds = builder.traceIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> traceIds() {
        return this.traceIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.traceIds() == null ? 0 : this.traceIds().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceGraphRequest)) {
            return false;
        }
        GetTraceGraphRequest other = (GetTraceGraphRequest)((Object)obj);
        if (other.traceIds() == null ^ this.traceIds() == null) {
            return false;
        }
        if (other.traceIds() != null && !other.traceIds().equals(this.traceIds())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.traceIds() != null) {
            sb.append("TraceIds: ").append(this.traceIds()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> traceIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTraceGraphRequest model) {
            this.setTraceIds(model.traceIds);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getTraceIds() {
            return this.traceIds;
        }

        @Override
        public final Builder traceIds(Collection<String> traceIds) {
            this.traceIds = TraceIdListCopier.copy(traceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traceIds(String ... traceIds) {
            this.traceIds(Arrays.asList(traceIds));
            return this;
        }

        public final void setTraceIds(Collection<String> traceIds) {
            this.traceIds = TraceIdListCopier.copy(traceIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetTraceGraphRequest build() {
            return new GetTraceGraphRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetTraceGraphRequest> {
        public Builder traceIds(Collection<String> var1);

        public Builder traceIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

