/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.xray.model.Service;
import software.amazon.awssdk.services.xray.model.ServiceListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetServiceGraphResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetServiceGraphResponse> {
    private final Instant startTime;
    private final Instant endTime;
    private final List<Service> services;
    private final String nextToken;

    private GetServiceGraphResponse(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.services = builder.services;
        this.nextToken = builder.nextToken;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public List<Service> services() {
        return this.services;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.services() == null ? 0 : this.services().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceGraphResponse)) {
            return false;
        }
        GetServiceGraphResponse other = (GetServiceGraphResponse)((Object)obj);
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.services() == null ^ this.services() == null) {
            return false;
        }
        if (other.services() != null && !other.services().equals(this.services())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.services() != null) {
            sb.append("Services: ").append(this.services()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private List<Service> services;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceGraphResponse model) {
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setServices(model.services);
            this.setNextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<Service> getServices() {
            return this.services;
        }

        @Override
        public final Builder services(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Service ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetServiceGraphResponse build() {
            return new GetServiceGraphResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetServiceGraphResponse> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder services(Collection<Service> var1);

        public Builder services(Service ... var1);

        public Builder nextToken(String var1);
    }
}

