/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.transform.AnnotationValueMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AnnotationValue
implements StructuredPojo,
ToCopyableBuilder<Builder, AnnotationValue> {
    private final Double numberValue;
    private final Boolean booleanValue;
    private final String stringValue;

    private AnnotationValue(BuilderImpl builder) {
        this.numberValue = builder.numberValue;
        this.booleanValue = builder.booleanValue;
        this.stringValue = builder.stringValue;
    }

    public Double numberValue() {
        return this.numberValue;
    }

    public Boolean booleanValue() {
        return this.booleanValue;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.numberValue() == null ? 0 : this.numberValue().hashCode());
        hashCode = 31 * hashCode + (this.booleanValue() == null ? 0 : this.booleanValue().hashCode());
        hashCode = 31 * hashCode + (this.stringValue() == null ? 0 : this.stringValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationValue)) {
            return false;
        }
        AnnotationValue other = (AnnotationValue)obj;
        if (other.numberValue() == null ^ this.numberValue() == null) {
            return false;
        }
        if (other.numberValue() != null && !other.numberValue().equals(this.numberValue())) {
            return false;
        }
        if (other.booleanValue() == null ^ this.booleanValue() == null) {
            return false;
        }
        if (other.booleanValue() != null && !other.booleanValue().equals(this.booleanValue())) {
            return false;
        }
        if (other.stringValue() == null ^ this.stringValue() == null) {
            return false;
        }
        return other.stringValue() == null || other.stringValue().equals(this.stringValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.numberValue() != null) {
            sb.append("NumberValue: ").append(this.numberValue()).append(",");
        }
        if (this.booleanValue() != null) {
            sb.append("BooleanValue: ").append(this.booleanValue()).append(",");
        }
        if (this.stringValue() != null) {
            sb.append("StringValue: ").append(this.stringValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnnotationValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Double numberValue;
        private Boolean booleanValue;
        private String stringValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AnnotationValue model) {
            this.setNumberValue(model.numberValue);
            this.setBooleanValue(model.booleanValue);
            this.setStringValue(model.stringValue);
        }

        public final Double getNumberValue() {
            return this.numberValue;
        }

        @Override
        public final Builder numberValue(Double numberValue) {
            this.numberValue = numberValue;
            return this;
        }

        public final void setNumberValue(Double numberValue) {
            this.numberValue = numberValue;
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public AnnotationValue build() {
            return new AnnotationValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AnnotationValue> {
        public Builder numberValue(Double var1);

        public Builder booleanValue(Boolean var1);

        public Builder stringValue(String var1);
    }
}

