/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.UnprocessedTraceSegment;

@SdkInternalApi
public class UnprocessedTraceSegmentMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final UnprocessedTraceSegmentMarshaller INSTANCE = new UnprocessedTraceSegmentMarshaller();

    public static UnprocessedTraceSegmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UnprocessedTraceSegment unprocessedTraceSegment, ProtocolMarshaller protocolMarshaller) {
        if (unprocessedTraceSegment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)unprocessedTraceSegment.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)unprocessedTraceSegment.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)unprocessedTraceSegment.message(), MESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

