/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTraceSummariesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetTraceSummariesRequest> {
    private final Instant startTime;
    private final Instant endTime;
    private final Boolean sampling;
    private final String filterExpression;
    private final String nextToken;

    private GetTraceSummariesRequest(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.sampling = builder.sampling;
        this.filterExpression = builder.filterExpression;
        this.nextToken = builder.nextToken;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Boolean sampling() {
        return this.sampling;
    }

    public String filterExpression() {
        return this.filterExpression;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.sampling() == null ? 0 : this.sampling().hashCode());
        hashCode = 31 * hashCode + (this.filterExpression() == null ? 0 : this.filterExpression().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceSummariesRequest)) {
            return false;
        }
        GetTraceSummariesRequest other = (GetTraceSummariesRequest)((Object)obj);
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.sampling() == null ^ this.sampling() == null) {
            return false;
        }
        if (other.sampling() != null && !other.sampling().equals(this.sampling())) {
            return false;
        }
        if (other.filterExpression() == null ^ this.filterExpression() == null) {
            return false;
        }
        if (other.filterExpression() != null && !other.filterExpression().equals(this.filterExpression())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.sampling() != null) {
            sb.append("Sampling: ").append(this.sampling()).append(",");
        }
        if (this.filterExpression() != null) {
            sb.append("FilterExpression: ").append(this.filterExpression()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private Boolean sampling;
        private String filterExpression;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTraceSummariesRequest model) {
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setSampling(model.sampling);
            this.setFilterExpression(model.filterExpression);
            this.setNextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Boolean getSampling() {
            return this.sampling;
        }

        @Override
        public final Builder sampling(Boolean sampling) {
            this.sampling = sampling;
            return this;
        }

        public final void setSampling(Boolean sampling) {
            this.sampling = sampling;
        }

        public final String getFilterExpression() {
            return this.filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetTraceSummariesRequest build() {
            return new GetTraceSummariesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetTraceSummariesRequest> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder sampling(Boolean var1);

        public Builder filterExpression(String var1);

        public Builder nextToken(String var1);
    }
}

