/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.Service;
import software.amazon.awssdk.services.xray.transform.EdgeUnmarshaller;
import software.amazon.awssdk.services.xray.transform.HistogramEntryUnmarshaller;
import software.amazon.awssdk.services.xray.transform.ServiceStatisticsUnmarshaller;

public class ServiceUnmarshaller
implements Unmarshaller<Service, JsonUnmarshallerContext> {
    private static ServiceUnmarshaller INSTANCE;

    public Service unmarshall(JsonUnmarshallerContext context) throws Exception {
        Service.Builder serviceBuilder = Service.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ReferenceId", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.referenceId((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Names", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.names(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Root", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.root((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("AccountId", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.accountId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StartTime", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.startTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("EndTime", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.endTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Edges", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.edges(new ListUnmarshaller((Unmarshaller)EdgeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("SummaryStatistics", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.summaryStatistics(ServiceStatisticsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DurationHistogram", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.durationHistogram(new ListUnmarshaller((Unmarshaller)HistogramEntryUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ResponseTimeHistogram", targetDepth)) {
                    context.nextToken();
                    serviceBuilder.responseTimeHistogram(new ListUnmarshaller((Unmarshaller)HistogramEntryUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Service)serviceBuilder.build();
    }

    public static ServiceUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ServiceUnmarshaller();
        }
        return INSTANCE;
    }
}

