/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.SamplingTargetDocument;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SamplingTargetDocumentMarshaller {
    private static final MarshallingInfo<String> RULENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleName").isBinary(false).build();
    private static final MarshallingInfo<Double> FIXEDRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FixedRate").isBinary(false).build();
    private static final MarshallingInfo<Integer> RESERVOIRQUOTA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservoirQuota").isBinary(false).build();
    private static final MarshallingInfo<Instant> RESERVOIRQUOTATTL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservoirQuotaTTL").isBinary(false).build();
    private static final MarshallingInfo<Integer> INTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Interval").isBinary(false).build();
    private static final SamplingTargetDocumentMarshaller INSTANCE = new SamplingTargetDocumentMarshaller();

    private SamplingTargetDocumentMarshaller() {
    }

    public static SamplingTargetDocumentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SamplingTargetDocument samplingTargetDocument, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)samplingTargetDocument, (String)"samplingTargetDocument");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)samplingTargetDocument.ruleName(), RULENAME_BINDING);
            protocolMarshaller.marshall((Object)samplingTargetDocument.fixedRate(), FIXEDRATE_BINDING);
            protocolMarshaller.marshall((Object)samplingTargetDocument.reservoirQuota(), RESERVOIRQUOTA_BINDING);
            protocolMarshaller.marshall((Object)samplingTargetDocument.reservoirQuotaTTL(), RESERVOIRQUOTATTL_BINDING);
            protocolMarshaller.marshall((Object)samplingTargetDocument.interval(), INTERVAL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

