/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutTelemetryRecordsRequestModelMarshaller {
    private static final MarshallingInfo<List> TELEMETRYRECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TelemetryRecords").isBinary(false).build();
    private static final MarshallingInfo<String> EC2INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EC2InstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hostname").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARN").isBinary(false).build();
    private static final PutTelemetryRecordsRequestModelMarshaller INSTANCE = new PutTelemetryRecordsRequestModelMarshaller();

    private PutTelemetryRecordsRequestModelMarshaller() {
    }

    public static PutTelemetryRecordsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutTelemetryRecordsRequest putTelemetryRecordsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putTelemetryRecordsRequest), (String)"putTelemetryRecordsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(putTelemetryRecordsRequest.telemetryRecords(), TELEMETRYRECORDS_BINDING);
            protocolMarshaller.marshall((Object)putTelemetryRecordsRequest.ec2InstanceId(), EC2INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)putTelemetryRecordsRequest.hostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)putTelemetryRecordsRequest.resourceARN(), RESOURCEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

