/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.EncryptionConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EncryptionConfigMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final EncryptionConfigMarshaller INSTANCE = new EncryptionConfigMarshaller();

    private EncryptionConfigMarshaller() {
    }

    public static EncryptionConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EncryptionConfig encryptionConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)encryptionConfig, (String)"encryptionConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)encryptionConfig.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)encryptionConfig.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)encryptionConfig.typeAsString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

