/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.SamplingRule;
import software.amazon.awssdk.services.xray.transform.SamplingRuleRecordMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamplingRuleRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, SamplingRuleRecord> {
    private final SamplingRule samplingRule;
    private final Instant createdAt;
    private final Instant modifiedAt;

    private SamplingRuleRecord(BuilderImpl builder) {
        this.samplingRule = builder.samplingRule;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    public SamplingRule samplingRule() {
        return this.samplingRule;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant modifiedAt() {
        return this.modifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingRuleRecord)) {
            return false;
        }
        SamplingRuleRecord other = (SamplingRuleRecord)obj;
        return Objects.equals(this.samplingRule(), other.samplingRule()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt());
    }

    public String toString() {
        return ToString.builder((String)"SamplingRuleRecord").add("SamplingRule", (Object)this.samplingRule()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SamplingRule": {
                return Optional.ofNullable(clazz.cast(this.samplingRule()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SamplingRuleRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private SamplingRule samplingRule;
        private Instant createdAt;
        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingRuleRecord model) {
            this.samplingRule(model.samplingRule);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
        }

        public final SamplingRule.Builder getSamplingRule() {
            return this.samplingRule != null ? this.samplingRule.toBuilder() : null;
        }

        @Override
        public final Builder samplingRule(SamplingRule samplingRule) {
            this.samplingRule = samplingRule;
            return this;
        }

        public final void setSamplingRule(SamplingRule.BuilderImpl samplingRule) {
            this.samplingRule = samplingRule != null ? samplingRule.build() : null;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        public SamplingRuleRecord build() {
            return new SamplingRuleRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SamplingRuleRecord> {
        public Builder samplingRule(SamplingRule var1);

        default public Builder samplingRule(Consumer<SamplingRule.Builder> samplingRule) {
            return this.samplingRule((SamplingRule)((SamplingRule.Builder)SamplingRule.builder().applyMutation(samplingRule)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);
    }
}

