/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.TelemetryRecord;
import software.amazon.awssdk.services.xray.model.TelemetryRecordListCopier;
import software.amazon.awssdk.services.xray.model.XRayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTelemetryRecordsRequest
extends XRayRequest
implements ToCopyableBuilder<Builder, PutTelemetryRecordsRequest> {
    private final List<TelemetryRecord> telemetryRecords;
    private final String ec2InstanceId;
    private final String hostname;
    private final String resourceARN;

    private PutTelemetryRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.telemetryRecords = builder.telemetryRecords;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.hostname = builder.hostname;
        this.resourceARN = builder.resourceARN;
    }

    public List<TelemetryRecord> telemetryRecords() {
        return this.telemetryRecords;
    }

    public String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public String hostname() {
        return this.hostname;
    }

    public String resourceARN() {
        return this.resourceARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.telemetryRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTelemetryRecordsRequest)) {
            return false;
        }
        PutTelemetryRecordsRequest other = (PutTelemetryRecordsRequest)((Object)obj);
        return Objects.equals(this.telemetryRecords(), other.telemetryRecords()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.resourceARN(), other.resourceARN());
    }

    public String toString() {
        return ToString.builder((String)"PutTelemetryRecordsRequest").add("TelemetryRecords", this.telemetryRecords()).add("EC2InstanceId", (Object)this.ec2InstanceId()).add("Hostname", (Object)this.hostname()).add("ResourceARN", (Object)this.resourceARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TelemetryRecords": {
                return Optional.ofNullable(clazz.cast(this.telemetryRecords()));
            }
            case "EC2InstanceId": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceId()));
            }
            case "Hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends XRayRequest.BuilderImpl
    implements Builder {
        private List<TelemetryRecord> telemetryRecords = DefaultSdkAutoConstructList.getInstance();
        private String ec2InstanceId;
        private String hostname;
        private String resourceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTelemetryRecordsRequest model) {
            super(model);
            this.telemetryRecords(model.telemetryRecords);
            this.ec2InstanceId(model.ec2InstanceId);
            this.hostname(model.hostname);
            this.resourceARN(model.resourceARN);
        }

        public final Collection<TelemetryRecord.Builder> getTelemetryRecords() {
            return this.telemetryRecords != null ? (Collection)this.telemetryRecords.stream().map(TelemetryRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder telemetryRecords(Collection<TelemetryRecord> telemetryRecords) {
            this.telemetryRecords = TelemetryRecordListCopier.copy(telemetryRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryRecords(TelemetryRecord ... telemetryRecords) {
            this.telemetryRecords(Arrays.asList(telemetryRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryRecords(Consumer<TelemetryRecord.Builder> ... telemetryRecords) {
            this.telemetryRecords(Stream.of(telemetryRecords).map(c -> (TelemetryRecord)((TelemetryRecord.Builder)TelemetryRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTelemetryRecords(Collection<TelemetryRecord.BuilderImpl> telemetryRecords) {
            this.telemetryRecords = TelemetryRecordListCopier.copyFromBuilder(telemetryRecords);
        }

        public final String getEC2InstanceId() {
            return this.ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEC2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTelemetryRecordsRequest build() {
            return new PutTelemetryRecordsRequest(this);
        }
    }

    public static interface Builder
    extends XRayRequest.Builder,
    CopyableBuilder<Builder, PutTelemetryRecordsRequest> {
        public Builder telemetryRecords(Collection<TelemetryRecord> var1);

        public Builder telemetryRecords(TelemetryRecord ... var1);

        public Builder telemetryRecords(Consumer<TelemetryRecord.Builder> ... var1);

        public Builder ec2InstanceId(String var1);

        public Builder hostname(String var1);

        public Builder resourceARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

