/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.SamplingStatisticSummary;
import software.amazon.awssdk.services.xray.model.SamplingStatisticSummaryListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSamplingStatisticSummariesResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetSamplingStatisticSummariesResponse> {
    private final List<SamplingStatisticSummary> samplingStatisticSummaries;
    private final String nextToken;

    private GetSamplingStatisticSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.samplingStatisticSummaries = builder.samplingStatisticSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<SamplingStatisticSummary> samplingStatisticSummaries() {
        return this.samplingStatisticSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingStatisticSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSamplingStatisticSummariesResponse)) {
            return false;
        }
        GetSamplingStatisticSummariesResponse other = (GetSamplingStatisticSummariesResponse)((Object)obj);
        return Objects.equals(this.samplingStatisticSummaries(), other.samplingStatisticSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetSamplingStatisticSummariesResponse").add("SamplingStatisticSummaries", this.samplingStatisticSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SamplingStatisticSummaries": {
                return Optional.ofNullable(clazz.cast(this.samplingStatisticSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<SamplingStatisticSummary> samplingStatisticSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSamplingStatisticSummariesResponse model) {
            super(model);
            this.samplingStatisticSummaries(model.samplingStatisticSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<SamplingStatisticSummary.Builder> getSamplingStatisticSummaries() {
            return this.samplingStatisticSummaries != null ? (Collection)this.samplingStatisticSummaries.stream().map(SamplingStatisticSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder samplingStatisticSummaries(Collection<SamplingStatisticSummary> samplingStatisticSummaries) {
            this.samplingStatisticSummaries = SamplingStatisticSummaryListCopier.copy(samplingStatisticSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingStatisticSummaries(SamplingStatisticSummary ... samplingStatisticSummaries) {
            this.samplingStatisticSummaries(Arrays.asList(samplingStatisticSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingStatisticSummaries(Consumer<SamplingStatisticSummary.Builder> ... samplingStatisticSummaries) {
            this.samplingStatisticSummaries(Stream.of(samplingStatisticSummaries).map(c -> (SamplingStatisticSummary)((SamplingStatisticSummary.Builder)SamplingStatisticSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSamplingStatisticSummaries(Collection<SamplingStatisticSummary.BuilderImpl> samplingStatisticSummaries) {
            this.samplingStatisticSummaries = SamplingStatisticSummaryListCopier.copyFromBuilder(samplingStatisticSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetSamplingStatisticSummariesResponse build() {
            return new GetSamplingStatisticSummariesResponse(this);
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    CopyableBuilder<Builder, GetSamplingStatisticSummariesResponse> {
        public Builder samplingStatisticSummaries(Collection<SamplingStatisticSummary> var1);

        public Builder samplingStatisticSummaries(SamplingStatisticSummary ... var1);

        public Builder samplingStatisticSummaries(Consumer<SamplingStatisticSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

