/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.model.BatchGetTracesRequest;
import software.amazon.awssdk.services.xray.model.BatchGetTracesResponse;
import software.amazon.awssdk.services.xray.model.CreateSamplingRuleRequest;
import software.amazon.awssdk.services.xray.model.CreateSamplingRuleResponse;
import software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest;
import software.amazon.awssdk.services.xray.model.DeleteSamplingRuleResponse;
import software.amazon.awssdk.services.xray.model.GetEncryptionConfigRequest;
import software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse;
import software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse;
import software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse;
import software.amazon.awssdk.services.xray.model.GetSamplingTargetsRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingTargetsResponse;
import software.amazon.awssdk.services.xray.model.GetServiceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetServiceGraphResponse;
import software.amazon.awssdk.services.xray.model.GetTraceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetTraceGraphResponse;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse;
import software.amazon.awssdk.services.xray.model.InvalidRequestException;
import software.amazon.awssdk.services.xray.model.PutEncryptionConfigRequest;
import software.amazon.awssdk.services.xray.model.PutEncryptionConfigResponse;
import software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest;
import software.amazon.awssdk.services.xray.model.PutTelemetryRecordsResponse;
import software.amazon.awssdk.services.xray.model.PutTraceSegmentsRequest;
import software.amazon.awssdk.services.xray.model.PutTraceSegmentsResponse;
import software.amazon.awssdk.services.xray.model.RuleLimitExceededException;
import software.amazon.awssdk.services.xray.model.ThrottledException;
import software.amazon.awssdk.services.xray.model.UpdateSamplingRuleRequest;
import software.amazon.awssdk.services.xray.model.UpdateSamplingRuleResponse;
import software.amazon.awssdk.services.xray.model.XRayException;
import software.amazon.awssdk.services.xray.transform.BatchGetTracesRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.BatchGetTracesResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.CreateSamplingRuleRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.CreateSamplingRuleResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.DeleteSamplingRuleRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.DeleteSamplingRuleResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.GetEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetEncryptionConfigResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.GetSamplingRulesRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetSamplingRulesResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.GetSamplingStatisticSummariesRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetSamplingStatisticSummariesResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.GetSamplingTargetsRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetSamplingTargetsResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.GetServiceGraphRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetServiceGraphResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.GetTraceGraphRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetTraceGraphResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.GetTraceSummariesRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetTraceSummariesResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.PutEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.PutEncryptionConfigResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.PutTelemetryRecordsRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.PutTelemetryRecordsResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.PutTraceSegmentsRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.PutTraceSegmentsResponseUnmarshaller;
import software.amazon.awssdk.services.xray.transform.UpdateSamplingRuleRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.UpdateSamplingRuleResponseUnmarshaller;

@SdkInternalApi
final class DefaultXRayClient
implements XRayClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultXRayClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "xray";
    }

    @Override
    public BatchGetTracesResponse batchGetTraces(BatchGetTracesRequest batchGetTracesRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetTracesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (BatchGetTracesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetTracesRequest).withMarshaller((Marshaller)new BatchGetTracesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateSamplingRuleResponse createSamplingRule(CreateSamplingRuleRequest createSamplingRuleRequest) throws InvalidRequestException, ThrottledException, RuleLimitExceededException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSamplingRuleResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateSamplingRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSamplingRuleRequest).withMarshaller((Marshaller)new CreateSamplingRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteSamplingRuleResponse deleteSamplingRule(DeleteSamplingRuleRequest deleteSamplingRuleRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSamplingRuleResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteSamplingRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSamplingRuleRequest).withMarshaller((Marshaller)new DeleteSamplingRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetEncryptionConfigResponse getEncryptionConfig(GetEncryptionConfigRequest getEncryptionConfigRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEncryptionConfigResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEncryptionConfigRequest).withMarshaller((Marshaller)new GetEncryptionConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSamplingRulesResponse getSamplingRules(GetSamplingRulesRequest getSamplingRulesRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSamplingRulesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetSamplingRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSamplingRulesRequest).withMarshaller((Marshaller)new GetSamplingRulesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSamplingStatisticSummariesResponse getSamplingStatisticSummaries(GetSamplingStatisticSummariesRequest getSamplingStatisticSummariesRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSamplingStatisticSummariesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetSamplingStatisticSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSamplingStatisticSummariesRequest).withMarshaller((Marshaller)new GetSamplingStatisticSummariesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSamplingTargetsResponse getSamplingTargets(GetSamplingTargetsRequest getSamplingTargetsRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSamplingTargetsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetSamplingTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSamplingTargetsRequest).withMarshaller((Marshaller)new GetSamplingTargetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetServiceGraphResponse getServiceGraph(GetServiceGraphRequest getServiceGraphRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetServiceGraphResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetServiceGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getServiceGraphRequest).withMarshaller((Marshaller)new GetServiceGraphRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetTraceGraphResponse getTraceGraph(GetTraceGraphRequest getTraceGraphRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTraceGraphResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetTraceGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTraceGraphRequest).withMarshaller((Marshaller)new GetTraceGraphRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetTraceSummariesResponse getTraceSummaries(GetTraceSummariesRequest getTraceSummariesRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTraceSummariesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetTraceSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTraceSummariesRequest).withMarshaller((Marshaller)new GetTraceSummariesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutEncryptionConfigResponse putEncryptionConfig(PutEncryptionConfigRequest putEncryptionConfigRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutEncryptionConfigResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEncryptionConfigRequest).withMarshaller((Marshaller)new PutEncryptionConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutTelemetryRecordsResponse putTelemetryRecords(PutTelemetryRecordsRequest putTelemetryRecordsRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutTelemetryRecordsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutTelemetryRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putTelemetryRecordsRequest).withMarshaller((Marshaller)new PutTelemetryRecordsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutTraceSegmentsResponse putTraceSegments(PutTraceSegmentsRequest putTraceSegmentsRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutTraceSegmentsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutTraceSegmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putTraceSegmentsRequest).withMarshaller((Marshaller)new PutTraceSegmentsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateSamplingRuleResponse updateSamplingRule(UpdateSamplingRuleRequest updateSamplingRuleRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSamplingRuleResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateSamplingRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSamplingRuleRequest).withMarshaller((Marshaller)new UpdateSamplingRuleRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(XRayException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottledException").withModeledClass(ThrottledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RuleLimitExceededException").withModeledClass(RuleLimitExceededException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.REST_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

