/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.Service;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServiceMarshaller {
    private static final MarshallingInfo<Integer> REFERENCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> NAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Names").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ROOT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Root").isBinary(false).build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<List> EDGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Edges").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SUMMARYSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SummaryStatistics").isBinary(false).build();
    private static final MarshallingInfo<List> DURATIONHISTOGRAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DurationHistogram").isBinary(false).build();
    private static final MarshallingInfo<List> RESPONSETIMEHISTOGRAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseTimeHistogram").isBinary(false).build();
    private static final ServiceMarshaller INSTANCE = new ServiceMarshaller();

    private ServiceMarshaller() {
    }

    public static ServiceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Service service, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)service, (String)"service");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)service.referenceId(), REFERENCEID_BINDING);
            protocolMarshaller.marshall((Object)service.name(), NAME_BINDING);
            protocolMarshaller.marshall(service.names(), NAMES_BINDING);
            protocolMarshaller.marshall((Object)service.root(), ROOT_BINDING);
            protocolMarshaller.marshall((Object)service.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)service.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)service.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)service.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)service.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(service.edges(), EDGES_BINDING);
            protocolMarshaller.marshall((Object)service.summaryStatistics(), SUMMARYSTATISTICS_BINDING);
            protocolMarshaller.marshall(service.durationHistogram(), DURATIONHISTOGRAM_BINDING);
            protocolMarshaller.marshall(service.responseTimeHistogram(), RESPONSETIMEHISTOGRAM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

