/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Date;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.TelemetryRecord;
import software.amazon.awssdk.services.xray.transform.BackendConnectionErrorsUnmarshaller;

public class TelemetryRecordUnmarshaller
implements Unmarshaller<TelemetryRecord, JsonUnmarshallerContext> {
    private static TelemetryRecordUnmarshaller INSTANCE;

    public TelemetryRecord unmarshall(JsonUnmarshallerContext context) throws Exception {
        TelemetryRecord.Builder telemetryRecordBuilder = TelemetryRecord.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Timestamp", targetDepth)) {
                    context.nextToken();
                    telemetryRecordBuilder.timestamp((Date)context.getUnmarshaller(Date.class).unmarshall((Object)context));
                }
                if (context.testExpression("SegmentsReceivedCount", targetDepth)) {
                    context.nextToken();
                    telemetryRecordBuilder.segmentsReceivedCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("SegmentsSentCount", targetDepth)) {
                    context.nextToken();
                    telemetryRecordBuilder.segmentsSentCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("SegmentsSpilloverCount", targetDepth)) {
                    context.nextToken();
                    telemetryRecordBuilder.segmentsSpilloverCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("SegmentsRejectedCount", targetDepth)) {
                    context.nextToken();
                    telemetryRecordBuilder.segmentsRejectedCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("BackendConnectionErrors", targetDepth)) {
                    context.nextToken();
                    telemetryRecordBuilder.backendConnectionErrors(BackendConnectionErrorsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TelemetryRecord)telemetryRecordBuilder.build();
    }

    public static TelemetryRecordUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TelemetryRecordUnmarshaller();
        }
        return INSTANCE;
    }
}

