/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.AnnotationValue;

public class AnnotationValueUnmarshaller
implements Unmarshaller<AnnotationValue, JsonUnmarshallerContext> {
    private static AnnotationValueUnmarshaller INSTANCE;

    public AnnotationValue unmarshall(JsonUnmarshallerContext context) throws Exception {
        AnnotationValue.Builder annotationValueBuilder = AnnotationValue.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("NumberValue", targetDepth)) {
                    context.nextToken();
                    annotationValueBuilder.numberValue((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("BooleanValue", targetDepth)) {
                    context.nextToken();
                    annotationValueBuilder.booleanValue((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("StringValue", targetDepth)) {
                    context.nextToken();
                    annotationValueBuilder.stringValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AnnotationValue)annotationValueBuilder.build();
    }

    public static AnnotationValueUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnnotationValueUnmarshaller();
        }
        return INSTANCE;
    }
}

