/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.xray.model.TelemetryRecord;
import software.amazon.awssdk.services.xray.model.TelemetryRecordListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutTelemetryRecordsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutTelemetryRecordsRequest> {
    private final List<TelemetryRecord> telemetryRecords;
    private final String ec2InstanceId;
    private final String hostname;
    private final String resourceARN;

    private PutTelemetryRecordsRequest(BuilderImpl builder) {
        this.telemetryRecords = builder.telemetryRecords;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.hostname = builder.hostname;
        this.resourceARN = builder.resourceARN;
    }

    public List<TelemetryRecord> telemetryRecords() {
        return this.telemetryRecords;
    }

    public String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public String hostname() {
        return this.hostname;
    }

    public String resourceARN() {
        return this.resourceARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.telemetryRecords() == null ? 0 : this.telemetryRecords().hashCode());
        hashCode = 31 * hashCode + (this.ec2InstanceId() == null ? 0 : this.ec2InstanceId().hashCode());
        hashCode = 31 * hashCode + (this.hostname() == null ? 0 : this.hostname().hashCode());
        hashCode = 31 * hashCode + (this.resourceARN() == null ? 0 : this.resourceARN().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTelemetryRecordsRequest)) {
            return false;
        }
        PutTelemetryRecordsRequest other = (PutTelemetryRecordsRequest)((Object)obj);
        if (other.telemetryRecords() == null ^ this.telemetryRecords() == null) {
            return false;
        }
        if (other.telemetryRecords() != null && !other.telemetryRecords().equals(this.telemetryRecords())) {
            return false;
        }
        if (other.ec2InstanceId() == null ^ this.ec2InstanceId() == null) {
            return false;
        }
        if (other.ec2InstanceId() != null && !other.ec2InstanceId().equals(this.ec2InstanceId())) {
            return false;
        }
        if (other.hostname() == null ^ this.hostname() == null) {
            return false;
        }
        if (other.hostname() != null && !other.hostname().equals(this.hostname())) {
            return false;
        }
        if (other.resourceARN() == null ^ this.resourceARN() == null) {
            return false;
        }
        return other.resourceARN() == null || other.resourceARN().equals(this.resourceARN());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.telemetryRecords() != null) {
            sb.append("TelemetryRecords: ").append(this.telemetryRecords()).append(",");
        }
        if (this.ec2InstanceId() != null) {
            sb.append("EC2InstanceId: ").append(this.ec2InstanceId()).append(",");
        }
        if (this.hostname() != null) {
            sb.append("Hostname: ").append(this.hostname()).append(",");
        }
        if (this.resourceARN() != null) {
            sb.append("ResourceARN: ").append(this.resourceARN()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<TelemetryRecord> telemetryRecords;
        private String ec2InstanceId;
        private String hostname;
        private String resourceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTelemetryRecordsRequest model) {
            this.setTelemetryRecords(model.telemetryRecords);
            this.setEC2InstanceId(model.ec2InstanceId);
            this.setHostname(model.hostname);
            this.setResourceARN(model.resourceARN);
        }

        public final Collection<TelemetryRecord> getTelemetryRecords() {
            return this.telemetryRecords;
        }

        @Override
        public final Builder telemetryRecords(Collection<TelemetryRecord> telemetryRecords) {
            this.telemetryRecords = TelemetryRecordListCopier.copy(telemetryRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryRecords(TelemetryRecord ... telemetryRecords) {
            if (this.telemetryRecords == null) {
                this.telemetryRecords = new ArrayList<TelemetryRecord>(telemetryRecords.length);
            }
            for (TelemetryRecord e : telemetryRecords) {
                this.telemetryRecords.add(e);
            }
            return this;
        }

        public final void setTelemetryRecords(Collection<TelemetryRecord> telemetryRecords) {
            this.telemetryRecords = TelemetryRecordListCopier.copy(telemetryRecords);
        }

        @SafeVarargs
        public final void setTelemetryRecords(TelemetryRecord ... telemetryRecords) {
            if (this.telemetryRecords == null) {
                this.telemetryRecords = new ArrayList<TelemetryRecord>(telemetryRecords.length);
            }
            for (TelemetryRecord e : telemetryRecords) {
                this.telemetryRecords.add(e);
            }
        }

        public final String getEC2InstanceId() {
            return this.ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEC2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public PutTelemetryRecordsRequest build() {
            return new PutTelemetryRecordsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutTelemetryRecordsRequest> {
        public Builder telemetryRecords(Collection<TelemetryRecord> var1);

        public Builder telemetryRecords(TelemetryRecord ... var1);

        public Builder ec2InstanceId(String var1);

        public Builder hostname(String var1);

        public Builder resourceARN(String var1);
    }
}

