/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.xray.model.TraceSummary;
import software.amazon.awssdk.services.xray.model.TraceSummaryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTraceSummariesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetTraceSummariesResponse> {
    private final List<TraceSummary> traceSummaries;
    private final Date approximateTime;
    private final Long tracesProcessedCount;
    private final String nextToken;

    private GetTraceSummariesResponse(BuilderImpl builder) {
        this.traceSummaries = builder.traceSummaries;
        this.approximateTime = builder.approximateTime;
        this.tracesProcessedCount = builder.tracesProcessedCount;
        this.nextToken = builder.nextToken;
    }

    public List<TraceSummary> traceSummaries() {
        return this.traceSummaries;
    }

    public Date approximateTime() {
        return this.approximateTime;
    }

    public Long tracesProcessedCount() {
        return this.tracesProcessedCount;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.traceSummaries() == null ? 0 : this.traceSummaries().hashCode());
        hashCode = 31 * hashCode + (this.approximateTime() == null ? 0 : this.approximateTime().hashCode());
        hashCode = 31 * hashCode + (this.tracesProcessedCount() == null ? 0 : this.tracesProcessedCount().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceSummariesResponse)) {
            return false;
        }
        GetTraceSummariesResponse other = (GetTraceSummariesResponse)((Object)obj);
        if (other.traceSummaries() == null ^ this.traceSummaries() == null) {
            return false;
        }
        if (other.traceSummaries() != null && !other.traceSummaries().equals(this.traceSummaries())) {
            return false;
        }
        if (other.approximateTime() == null ^ this.approximateTime() == null) {
            return false;
        }
        if (other.approximateTime() != null && !other.approximateTime().equals(this.approximateTime())) {
            return false;
        }
        if (other.tracesProcessedCount() == null ^ this.tracesProcessedCount() == null) {
            return false;
        }
        if (other.tracesProcessedCount() != null && !other.tracesProcessedCount().equals(this.tracesProcessedCount())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.traceSummaries() != null) {
            sb.append("TraceSummaries: ").append(this.traceSummaries()).append(",");
        }
        if (this.approximateTime() != null) {
            sb.append("ApproximateTime: ").append(this.approximateTime()).append(",");
        }
        if (this.tracesProcessedCount() != null) {
            sb.append("TracesProcessedCount: ").append(this.tracesProcessedCount()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<TraceSummary> traceSummaries;
        private Date approximateTime;
        private Long tracesProcessedCount;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTraceSummariesResponse model) {
            this.setTraceSummaries(model.traceSummaries);
            this.setApproximateTime(model.approximateTime);
            this.setTracesProcessedCount(model.tracesProcessedCount);
            this.setNextToken(model.nextToken);
        }

        public final Collection<TraceSummary> getTraceSummaries() {
            return this.traceSummaries;
        }

        @Override
        public final Builder traceSummaries(Collection<TraceSummary> traceSummaries) {
            this.traceSummaries = TraceSummaryListCopier.copy(traceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traceSummaries(TraceSummary ... traceSummaries) {
            if (this.traceSummaries == null) {
                this.traceSummaries = new ArrayList<TraceSummary>(traceSummaries.length);
            }
            for (TraceSummary e : traceSummaries) {
                this.traceSummaries.add(e);
            }
            return this;
        }

        public final void setTraceSummaries(Collection<TraceSummary> traceSummaries) {
            this.traceSummaries = TraceSummaryListCopier.copy(traceSummaries);
        }

        @SafeVarargs
        public final void setTraceSummaries(TraceSummary ... traceSummaries) {
            if (this.traceSummaries == null) {
                this.traceSummaries = new ArrayList<TraceSummary>(traceSummaries.length);
            }
            for (TraceSummary e : traceSummaries) {
                this.traceSummaries.add(e);
            }
        }

        public final Date getApproximateTime() {
            return this.approximateTime;
        }

        @Override
        public final Builder approximateTime(Date approximateTime) {
            this.approximateTime = StandardMemberCopier.copy((Date)approximateTime);
            return this;
        }

        public final void setApproximateTime(Date approximateTime) {
            this.approximateTime = StandardMemberCopier.copy((Date)approximateTime);
        }

        public final Long getTracesProcessedCount() {
            return this.tracesProcessedCount;
        }

        @Override
        public final Builder tracesProcessedCount(Long tracesProcessedCount) {
            this.tracesProcessedCount = tracesProcessedCount;
            return this;
        }

        public final void setTracesProcessedCount(Long tracesProcessedCount) {
            this.tracesProcessedCount = tracesProcessedCount;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetTraceSummariesResponse build() {
            return new GetTraceSummariesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetTraceSummariesResponse> {
        public Builder traceSummaries(Collection<TraceSummary> var1);

        public Builder traceSummaries(TraceSummary ... var1);

        public Builder approximateTime(Date var1);

        public Builder tracesProcessedCount(Long var1);

        public Builder nextToken(String var1);
    }
}

