/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.xray.model.Trace;
import software.amazon.awssdk.services.xray.model.TraceListCopier;
import software.amazon.awssdk.services.xray.model.UnprocessedTraceIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetTracesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetTracesResponse> {
    private final List<Trace> traces;
    private final List<String> unprocessedTraceIds;
    private final String nextToken;

    private BatchGetTracesResponse(BuilderImpl builder) {
        this.traces = builder.traces;
        this.unprocessedTraceIds = builder.unprocessedTraceIds;
        this.nextToken = builder.nextToken;
    }

    public List<Trace> traces() {
        return this.traces;
    }

    public List<String> unprocessedTraceIds() {
        return this.unprocessedTraceIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.traces() == null ? 0 : this.traces().hashCode());
        hashCode = 31 * hashCode + (this.unprocessedTraceIds() == null ? 0 : this.unprocessedTraceIds().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTracesResponse)) {
            return false;
        }
        BatchGetTracesResponse other = (BatchGetTracesResponse)((Object)obj);
        if (other.traces() == null ^ this.traces() == null) {
            return false;
        }
        if (other.traces() != null && !other.traces().equals(this.traces())) {
            return false;
        }
        if (other.unprocessedTraceIds() == null ^ this.unprocessedTraceIds() == null) {
            return false;
        }
        if (other.unprocessedTraceIds() != null && !other.unprocessedTraceIds().equals(this.unprocessedTraceIds())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.traces() != null) {
            sb.append("Traces: ").append(this.traces()).append(",");
        }
        if (this.unprocessedTraceIds() != null) {
            sb.append("UnprocessedTraceIds: ").append(this.unprocessedTraceIds()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Trace> traces;
        private List<String> unprocessedTraceIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTracesResponse model) {
            this.setTraces(model.traces);
            this.setUnprocessedTraceIds(model.unprocessedTraceIds);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Trace> getTraces() {
            return this.traces;
        }

        @Override
        public final Builder traces(Collection<Trace> traces) {
            this.traces = TraceListCopier.copy(traces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traces(Trace ... traces) {
            if (this.traces == null) {
                this.traces = new ArrayList<Trace>(traces.length);
            }
            for (Trace e : traces) {
                this.traces.add(e);
            }
            return this;
        }

        public final void setTraces(Collection<Trace> traces) {
            this.traces = TraceListCopier.copy(traces);
        }

        @SafeVarargs
        public final void setTraces(Trace ... traces) {
            if (this.traces == null) {
                this.traces = new ArrayList<Trace>(traces.length);
            }
            for (Trace e : traces) {
                this.traces.add(e);
            }
        }

        public final Collection<String> getUnprocessedTraceIds() {
            return this.unprocessedTraceIds;
        }

        @Override
        public final Builder unprocessedTraceIds(Collection<String> unprocessedTraceIds) {
            this.unprocessedTraceIds = UnprocessedTraceIdListCopier.copy(unprocessedTraceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedTraceIds(String ... unprocessedTraceIds) {
            if (this.unprocessedTraceIds == null) {
                this.unprocessedTraceIds = new ArrayList<String>(unprocessedTraceIds.length);
            }
            for (String e : unprocessedTraceIds) {
                this.unprocessedTraceIds.add(e);
            }
            return this;
        }

        public final void setUnprocessedTraceIds(Collection<String> unprocessedTraceIds) {
            this.unprocessedTraceIds = UnprocessedTraceIdListCopier.copy(unprocessedTraceIds);
        }

        @SafeVarargs
        public final void setUnprocessedTraceIds(String ... unprocessedTraceIds) {
            if (this.unprocessedTraceIds == null) {
                this.unprocessedTraceIds = new ArrayList<String>(unprocessedTraceIds.length);
            }
            for (String e : unprocessedTraceIds) {
                this.unprocessedTraceIds.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public BatchGetTracesResponse build() {
            return new BatchGetTracesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetTracesResponse> {
        public Builder traces(Collection<Trace> var1);

        public Builder traces(Trace ... var1);

        public Builder unprocessedTraceIds(Collection<String> var1);

        public Builder unprocessedTraceIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

