/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.PortalListCopier;
import software.amazon.awssdk.services.workspacesweb.model.PortalSummary;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPortalsResponse
extends WorkSpacesWebResponse
implements ToCopyableBuilder<Builder, ListPortalsResponse> {
    private static final SdkField<List<PortalSummary>> PORTALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("portals").getter(ListPortalsResponse.getter(ListPortalsResponse::portals)).setter(ListPortalsResponse.setter(Builder::portals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortalSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPortalsResponse.getter(ListPortalsResponse::nextToken)).setter(ListPortalsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTALS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPortalsResponse.memberNameToFieldInitializer();
    private final List<PortalSummary> portals;
    private final String nextToken;

    private ListPortalsResponse(BuilderImpl builder) {
        super(builder);
        this.portals = builder.portals;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPortals() {
        return this.portals != null && !(this.portals instanceof SdkAutoConstructList);
    }

    public final List<PortalSummary> portals() {
        return this.portals;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortals() ? this.portals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPortalsResponse)) {
            return false;
        }
        ListPortalsResponse other = (ListPortalsResponse)((Object)obj);
        return this.hasPortals() == other.hasPortals() && Objects.equals(this.portals(), other.portals()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPortalsResponse").add("Portals", this.hasPortals() ? this.portals() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portals": {
                return Optional.ofNullable(clazz.cast(this.portals()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("portals", PORTALS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPortalsResponse, T> g) {
        return obj -> g.apply((ListPortalsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebResponse.BuilderImpl
    implements Builder {
        private List<PortalSummary> portals = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPortalsResponse model) {
            super(model);
            this.portals(model.portals);
            this.nextToken(model.nextToken);
        }

        public final List<PortalSummary.Builder> getPortals() {
            List<PortalSummary.Builder> result = PortalListCopier.copyToBuilder(this.portals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortals(Collection<PortalSummary.BuilderImpl> portals) {
            this.portals = PortalListCopier.copyFromBuilder(portals);
        }

        @Override
        public final Builder portals(Collection<PortalSummary> portals) {
            this.portals = PortalListCopier.copy(portals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portals(PortalSummary ... portals) {
            this.portals(Arrays.asList(portals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portals(Consumer<PortalSummary.Builder> ... portals) {
            this.portals(Stream.of(portals).map(c -> (PortalSummary)((PortalSummary.Builder)PortalSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPortalsResponse build() {
            return new ListPortalsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesWebResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPortalsResponse> {
        public Builder portals(Collection<PortalSummary> var1);

        public Builder portals(PortalSummary ... var1);

        public Builder portals(Consumer<PortalSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

