/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesweb.model.ArnListCopier;
import software.amazon.awssdk.services.workspacesweb.model.EncryptionContextMapCopier;
import software.amazon.awssdk.services.workspacesweb.model.IpRule;
import software.amazon.awssdk.services.workspacesweb.model.IpRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpAccessSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpAccessSettings> {
    private static final SdkField<String> IP_ACCESS_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAccessSettingsArn").getter(IpAccessSettings.getter(IpAccessSettings::ipAccessSettingsArn)).setter(IpAccessSettings.setter(Builder::ipAccessSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAccessSettingsArn").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedPortalArns").getter(IpAccessSettings.getter(IpAccessSettings::associatedPortalArns)).setter(IpAccessSettings.setter(Builder::associatedPortalArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<IpRule>> IP_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipRules").getter(IpAccessSettings.getter(IpAccessSettings::ipRules)).setter(IpAccessSettings.setter(Builder::ipRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(IpAccessSettings.getter(IpAccessSettings::displayName)).setter(IpAccessSettings.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(IpAccessSettings.getter(IpAccessSettings::description)).setter(IpAccessSettings.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(IpAccessSettings.getter(IpAccessSettings::creationDate)).setter(IpAccessSettings.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerManagedKey").getter(IpAccessSettings.getter(IpAccessSettings::customerManagedKey)).setter(IpAccessSettings.setter(Builder::customerManagedKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalEncryptionContext").getter(IpAccessSettings.getter(IpAccessSettings::additionalEncryptionContext)).setter(IpAccessSettings.setter(Builder::additionalEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ACCESS_SETTINGS_ARN_FIELD, ASSOCIATED_PORTAL_ARNS_FIELD, IP_RULES_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, CREATION_DATE_FIELD, CUSTOMER_MANAGED_KEY_FIELD, ADDITIONAL_ENCRYPTION_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpAccessSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ipAccessSettingsArn;
    private final List<String> associatedPortalArns;
    private final List<IpRule> ipRules;
    private final String displayName;
    private final String description;
    private final Instant creationDate;
    private final String customerManagedKey;
    private final Map<String, String> additionalEncryptionContext;

    private IpAccessSettings(BuilderImpl builder) {
        this.ipAccessSettingsArn = builder.ipAccessSettingsArn;
        this.associatedPortalArns = builder.associatedPortalArns;
        this.ipRules = builder.ipRules;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.creationDate = builder.creationDate;
        this.customerManagedKey = builder.customerManagedKey;
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
    }

    public final String ipAccessSettingsArn() {
        return this.ipAccessSettingsArn;
    }

    public final boolean hasAssociatedPortalArns() {
        return this.associatedPortalArns != null && !(this.associatedPortalArns instanceof SdkAutoConstructList);
    }

    public final List<String> associatedPortalArns() {
        return this.associatedPortalArns;
    }

    public final boolean hasIpRules() {
        return this.ipRules != null && !(this.ipRules instanceof SdkAutoConstructList);
    }

    public final List<IpRule> ipRules() {
        return this.ipRules;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String customerManagedKey() {
        return this.customerManagedKey;
    }

    public final boolean hasAdditionalEncryptionContext() {
        return this.additionalEncryptionContext != null && !(this.additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAccessSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpRules() ? this.ipRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManagedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAccessSettings)) {
            return false;
        }
        IpAccessSettings other = (IpAccessSettings)obj;
        return Objects.equals(this.ipAccessSettingsArn(), other.ipAccessSettingsArn()) && this.hasAssociatedPortalArns() == other.hasAssociatedPortalArns() && Objects.equals(this.associatedPortalArns(), other.associatedPortalArns()) && this.hasIpRules() == other.hasIpRules() && Objects.equals(this.ipRules(), other.ipRules()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.customerManagedKey(), other.customerManagedKey()) && this.hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext() && Objects.equals(this.additionalEncryptionContext(), other.additionalEncryptionContext());
    }

    public final String toString() {
        return ToString.builder((String)"IpAccessSettings").add("IpAccessSettingsArn", (Object)this.ipAccessSettingsArn()).add("AssociatedPortalArns", this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null).add("IpRules", (Object)(this.ipRules() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("CreationDate", (Object)this.creationDate()).add("CustomerManagedKey", (Object)this.customerManagedKey()).add("AdditionalEncryptionContext", this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ipAccessSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.ipAccessSettingsArn()));
            }
            case "associatedPortalArns": {
                return Optional.ofNullable(clazz.cast(this.associatedPortalArns()));
            }
            case "ipRules": {
                return Optional.ofNullable(clazz.cast(this.ipRules()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "customerManagedKey": {
                return Optional.ofNullable(clazz.cast(this.customerManagedKey()));
            }
            case "additionalEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.additionalEncryptionContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ipAccessSettingsArn", IP_ACCESS_SETTINGS_ARN_FIELD);
        map.put("associatedPortalArns", ASSOCIATED_PORTAL_ARNS_FIELD);
        map.put("ipRules", IP_RULES_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("customerManagedKey", CUSTOMER_MANAGED_KEY_FIELD);
        map.put("additionalEncryptionContext", ADDITIONAL_ENCRYPTION_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpAccessSettings, T> g) {
        return obj -> g.apply((IpAccessSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipAccessSettingsArn;
        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();
        private List<IpRule> ipRules = DefaultSdkAutoConstructList.getInstance();
        private String displayName;
        private String description;
        private Instant creationDate;
        private String customerManagedKey;
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpAccessSettings model) {
            this.ipAccessSettingsArn(model.ipAccessSettingsArn);
            this.associatedPortalArns(model.associatedPortalArns);
            this.ipRules(model.ipRules);
            this.displayName(model.displayName);
            this.description(model.description);
            this.creationDate(model.creationDate);
            this.customerManagedKey(model.customerManagedKey);
            this.additionalEncryptionContext(model.additionalEncryptionContext);
        }

        public final String getIpAccessSettingsArn() {
            return this.ipAccessSettingsArn;
        }

        public final void setIpAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
        }

        @Override
        public final Builder ipAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
            return this;
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (this.associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String ... associatedPortalArns) {
            this.associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final List<IpRule.Builder> getIpRules() {
            List<IpRule.Builder> result = IpRuleListCopier.copyToBuilder(this.ipRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpRules(Collection<IpRule.BuilderImpl> ipRules) {
            this.ipRules = IpRuleListCopier.copyFromBuilder(ipRules);
        }

        @Override
        public final Builder ipRules(Collection<IpRule> ipRules) {
            this.ipRules = IpRuleListCopier.copy(ipRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRules(IpRule ... ipRules) {
            this.ipRules(Arrays.asList(ipRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRules(Consumer<IpRule.Builder> ... ipRules) {
            this.ipRules(Stream.of(ipRules).map(c -> (IpRule)((IpRule.Builder)IpRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getCustomerManagedKey() {
            return this.customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (this.additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public IpAccessSettings build() {
            return new IpAccessSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpAccessSettings> {
        public Builder ipAccessSettingsArn(String var1);

        public Builder associatedPortalArns(Collection<String> var1);

        public Builder associatedPortalArns(String ... var1);

        public Builder ipRules(Collection<IpRule> var1);

        public Builder ipRules(IpRule ... var1);

        public Builder ipRules(Consumer<IpRule.Builder> ... var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder creationDate(Instant var1);

        public Builder customerManagedKey(String var1);

        public Builder additionalEncryptionContext(Map<String, String> var1);
    }
}

