/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesweb.model.MimeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageMetadata> {
    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mimeType").getter(ImageMetadata.getter(ImageMetadata::mimeTypeAsString)).setter(ImageMetadata.setter(Builder::mimeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mimeType").build()}).build();
    private static final SdkField<String> FILE_EXTENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileExtension").getter(ImageMetadata.getter(ImageMetadata::fileExtension)).setter(ImageMetadata.setter(Builder::fileExtension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileExtension").build()}).build();
    private static final SdkField<Instant> LAST_UPLOAD_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUploadTimestamp").getter(ImageMetadata.getter(ImageMetadata::lastUploadTimestamp)).setter(ImageMetadata.setter(Builder::lastUploadTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUploadTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIME_TYPE_FIELD, FILE_EXTENSION_FIELD, LAST_UPLOAD_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mimeType;
    private final String fileExtension;
    private final Instant lastUploadTimestamp;

    private ImageMetadata(BuilderImpl builder) {
        this.mimeType = builder.mimeType;
        this.fileExtension = builder.fileExtension;
        this.lastUploadTimestamp = builder.lastUploadTimestamp;
    }

    public final MimeType mimeType() {
        return MimeType.fromValue(this.mimeType);
    }

    public final String mimeTypeAsString() {
        return this.mimeType;
    }

    public final String fileExtension() {
        return this.fileExtension;
    }

    public final Instant lastUploadTimestamp() {
        return this.lastUploadTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mimeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileExtension());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUploadTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageMetadata)) {
            return false;
        }
        ImageMetadata other = (ImageMetadata)obj;
        return Objects.equals(this.mimeTypeAsString(), other.mimeTypeAsString()) && Objects.equals(this.fileExtension(), other.fileExtension()) && Objects.equals(this.lastUploadTimestamp(), other.lastUploadTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ImageMetadata").add("MimeType", (Object)this.mimeTypeAsString()).add("FileExtension", (Object)this.fileExtension()).add("LastUploadTimestamp", (Object)this.lastUploadTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mimeType": {
                return Optional.ofNullable(clazz.cast(this.mimeTypeAsString()));
            }
            case "fileExtension": {
                return Optional.ofNullable(clazz.cast(this.fileExtension()));
            }
            case "lastUploadTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUploadTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mimeType", MIME_TYPE_FIELD);
        map.put("fileExtension", FILE_EXTENSION_FIELD);
        map.put("lastUploadTimestamp", LAST_UPLOAD_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageMetadata, T> g) {
        return obj -> g.apply((ImageMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mimeType;
        private String fileExtension;
        private Instant lastUploadTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageMetadata model) {
            this.mimeType(model.mimeType);
            this.fileExtension(model.fileExtension);
            this.lastUploadTimestamp(model.lastUploadTimestamp);
        }

        public final String getMimeType() {
            return this.mimeType;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public final Builder mimeType(MimeType mimeType) {
            this.mimeType(mimeType == null ? null : mimeType.toString());
            return this;
        }

        public final String getFileExtension() {
            return this.fileExtension;
        }

        public final void setFileExtension(String fileExtension) {
            this.fileExtension = fileExtension;
        }

        @Override
        public final Builder fileExtension(String fileExtension) {
            this.fileExtension = fileExtension;
            return this;
        }

        public final Instant getLastUploadTimestamp() {
            return this.lastUploadTimestamp;
        }

        public final void setLastUploadTimestamp(Instant lastUploadTimestamp) {
            this.lastUploadTimestamp = lastUploadTimestamp;
        }

        @Override
        public final Builder lastUploadTimestamp(Instant lastUploadTimestamp) {
            this.lastUploadTimestamp = lastUploadTimestamp;
            return this;
        }

        public ImageMetadata build() {
            return new ImageMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageMetadata> {
        public Builder mimeType(String var1);

        public Builder mimeType(MimeType var1);

        public Builder fileExtension(String var1);

        public Builder lastUploadTimestamp(Instant var1);
    }
}

