/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.IpRule;
import software.amazon.awssdk.services.workspacesweb.model.IpRuleListCopier;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIpAccessSettingsRequest
extends WorkSpacesWebRequest
implements ToCopyableBuilder<Builder, UpdateIpAccessSettingsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateIpAccessSettingsRequest.getter(UpdateIpAccessSettingsRequest::clientToken)).setter(UpdateIpAccessSettingsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateIpAccessSettingsRequest.getter(UpdateIpAccessSettingsRequest::description)).setter(UpdateIpAccessSettingsRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateIpAccessSettingsRequest.getter(UpdateIpAccessSettingsRequest::displayName)).setter(UpdateIpAccessSettingsRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> IP_ACCESS_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAccessSettingsArn").getter(UpdateIpAccessSettingsRequest.getter(UpdateIpAccessSettingsRequest::ipAccessSettingsArn)).setter(UpdateIpAccessSettingsRequest.setter(Builder::ipAccessSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("ipAccessSettingsArn").build()}).build();
    private static final SdkField<List<IpRule>> IP_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipRules").getter(UpdateIpAccessSettingsRequest.getter(UpdateIpAccessSettingsRequest::ipRules)).setter(UpdateIpAccessSettingsRequest.setter(Builder::ipRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, IP_ACCESS_SETTINGS_ARN_FIELD, IP_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateIpAccessSettingsRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String description;
    private final String displayName;
    private final String ipAccessSettingsArn;
    private final List<IpRule> ipRules;

    private UpdateIpAccessSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.ipAccessSettingsArn = builder.ipAccessSettingsArn;
        this.ipRules = builder.ipRules;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String ipAccessSettingsArn() {
        return this.ipAccessSettingsArn;
    }

    public final boolean hasIpRules() {
        return this.ipRules != null && !(this.ipRules instanceof SdkAutoConstructList);
    }

    public final List<IpRule> ipRules() {
        return this.ipRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAccessSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpRules() ? this.ipRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIpAccessSettingsRequest)) {
            return false;
        }
        UpdateIpAccessSettingsRequest other = (UpdateIpAccessSettingsRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.ipAccessSettingsArn(), other.ipAccessSettingsArn()) && this.hasIpRules() == other.hasIpRules() && Objects.equals(this.ipRules(), other.ipRules());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIpAccessSettingsRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("IpAccessSettingsArn", (Object)this.ipAccessSettingsArn()).add("IpRules", (Object)(this.ipRules() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "ipAccessSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.ipAccessSettingsArn()));
            }
            case "ipRules": {
                return Optional.ofNullable(clazz.cast(this.ipRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("ipAccessSettingsArn", IP_ACCESS_SETTINGS_ARN_FIELD);
        map.put("ipRules", IP_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIpAccessSettingsRequest, T> g) {
        return obj -> g.apply((UpdateIpAccessSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String displayName;
        private String ipAccessSettingsArn;
        private List<IpRule> ipRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIpAccessSettingsRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.displayName(model.displayName);
            this.ipAccessSettingsArn(model.ipAccessSettingsArn);
            this.ipRules(model.ipRules);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getIpAccessSettingsArn() {
            return this.ipAccessSettingsArn;
        }

        public final void setIpAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
        }

        @Override
        public final Builder ipAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
            return this;
        }

        public final List<IpRule.Builder> getIpRules() {
            List<IpRule.Builder> result = IpRuleListCopier.copyToBuilder(this.ipRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpRules(Collection<IpRule.BuilderImpl> ipRules) {
            this.ipRules = IpRuleListCopier.copyFromBuilder(ipRules);
        }

        @Override
        public final Builder ipRules(Collection<IpRule> ipRules) {
            this.ipRules = IpRuleListCopier.copy(ipRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRules(IpRule ... ipRules) {
            this.ipRules(Arrays.asList(ipRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRules(Consumer<IpRule.Builder> ... ipRules) {
            this.ipRules(Stream.of(ipRules).map(c -> (IpRule)((IpRule.Builder)IpRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIpAccessSettingsRequest build() {
            return new UpdateIpAccessSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesWebRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIpAccessSettingsRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder ipAccessSettingsArn(String var1);

        public Builder ipRules(Collection<IpRule> var1);

        public Builder ipRules(IpRule ... var1);

        public Builder ipRules(Consumer<IpRule.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

