/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse;

public class ListIpAccessSettingsPublisher
implements SdkPublisher<ListIpAccessSettingsResponse> {
    private final WorkSpacesWebAsyncClient client;
    private final ListIpAccessSettingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIpAccessSettingsPublisher(WorkSpacesWebAsyncClient client, ListIpAccessSettingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIpAccessSettingsPublisher(WorkSpacesWebAsyncClient client, ListIpAccessSettingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIpAccessSettingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIpAccessSettingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListIpAccessSettingsResponseFetcher
    implements AsyncPageFetcher<ListIpAccessSettingsResponse> {
        private ListIpAccessSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListIpAccessSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIpAccessSettingsResponse> nextPage(ListIpAccessSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListIpAccessSettingsPublisher.this.client.listIpAccessSettings(ListIpAccessSettingsPublisher.this.firstRequest);
            }
            return ListIpAccessSettingsPublisher.this.client.listIpAccessSettings((ListIpAccessSettingsRequest)((Object)ListIpAccessSettingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

