/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse;

public class ListIpAccessSettingsIterable
implements SdkIterable<ListIpAccessSettingsResponse> {
    private final WorkSpacesWebClient client;
    private final ListIpAccessSettingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIpAccessSettingsIterable(WorkSpacesWebClient client, ListIpAccessSettingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIpAccessSettingsResponseFetcher();
    }

    public Iterator<ListIpAccessSettingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListIpAccessSettingsResponseFetcher
    implements SyncPageFetcher<ListIpAccessSettingsResponse> {
        private ListIpAccessSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListIpAccessSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIpAccessSettingsResponse nextPage(ListIpAccessSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListIpAccessSettingsIterable.this.client.listIpAccessSettings(ListIpAccessSettingsIterable.this.firstRequest);
            }
            return ListIpAccessSettingsIterable.this.client.listIpAccessSettings((ListIpAccessSettingsRequest)((Object)ListIpAccessSettingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

