/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse;

public class ListTrustStoresPublisher
implements SdkPublisher<ListTrustStoresResponse> {
    private final WorkSpacesWebAsyncClient client;
    private final ListTrustStoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrustStoresPublisher(WorkSpacesWebAsyncClient client, ListTrustStoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrustStoresPublisher(WorkSpacesWebAsyncClient client, ListTrustStoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrustStoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrustStoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTrustStoresResponseFetcher
    implements AsyncPageFetcher<ListTrustStoresResponse> {
        private ListTrustStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListTrustStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrustStoresResponse> nextPage(ListTrustStoresResponse previousPage) {
            if (previousPage == null) {
                return ListTrustStoresPublisher.this.client.listTrustStores(ListTrustStoresPublisher.this.firstRequest);
            }
            return ListTrustStoresPublisher.this.client.listTrustStores((ListTrustStoresRequest)((Object)ListTrustStoresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

